package io.syndesis.server.metrics.jsondb;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link RawMetrics}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new RawMetrics.Builder()}.
 */
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "RawMetrics"})
@Immutable
public final class ImmutableRawMetrics implements RawMetrics {
  private final String integrationId;
  private final String version;
  private final String pod;
  private final Long messages;
  private final Long errors;
  private final @Nullable Date startDate;
  private final @Nullable Date resetDate;
  private final @Nullable Date lastProcessed;

  private ImmutableRawMetrics(
      String integrationId,
      String version,
      String pod,
      Long messages,
      Long errors,
      @Nullable Date startDate,
      @Nullable Date resetDate,
      @Nullable Date lastProcessed) {
    this.integrationId = integrationId;
    this.version = version;
    this.pod = pod;
    this.messages = messages;
    this.errors = errors;
    this.startDate = startDate;
    this.resetDate = resetDate;
    this.lastProcessed = lastProcessed;
  }

  /**
   * @return The value of the {@code integrationId} attribute
   */
  @JsonProperty("integrationId")
  @Override
  public String getIntegrationId() {
    return integrationId;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code pod} attribute
   */
  @JsonProperty("pod")
  @Override
  public String getPod() {
    return pod;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @JsonProperty("messages")
  @Override
  public Long getMessages() {
    return messages;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public Long getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code startDate} attribute
   */
  @JsonProperty("startDate")
  @Override
  public Optional<Date> getStartDate() {
    return Optional.ofNullable(startDate);
  }

  /**
   * @return The value of the {@code resetDate} attribute
   */
  @JsonProperty("resetDate")
  @Override
  public Optional<Date> getResetDate() {
    return Optional.ofNullable(resetDate);
  }

  /**
   * @return The value of the {@code lastProcessed} attribute
   */
  @JsonProperty("lastProcessed")
  @Override
  public Optional<Date> getLastProcessed() {
    return Optional.ofNullable(lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawMetrics#getIntegrationId() integrationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integrationId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawMetrics withIntegrationId(String value) {
    if (this.integrationId.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "integrationId");
    return new ImmutableRawMetrics(
        newValue,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawMetrics#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawMetrics withVersion(String value) {
    if (this.version.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "version");
    return new ImmutableRawMetrics(
        this.integrationId,
        newValue,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawMetrics#getPod() pod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawMetrics withPod(String value) {
    if (this.pod.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "pod");
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        newValue,
        this.messages,
        this.errors,
        this.startDate,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawMetrics#getMessages() messages} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messages
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawMetrics withMessages(Long value) {
    if (this.messages.equals(value)) return this;
    Long newValue = Objects.requireNonNull(value, "messages");
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        newValue,
        this.errors,
        this.startDate,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RawMetrics#getErrors() errors} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errors
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRawMetrics withErrors(Long value) {
    if (this.errors.equals(value)) return this;
    Long newValue = Objects.requireNonNull(value, "errors");
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        newValue,
        this.startDate,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RawMetrics#getStartDate() startDate} attribute.
   * @param value The value for startDate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withStartDate(Date value) {
    @Nullable Date newValue = Objects.requireNonNull(value, "startDate");
    if (this.startDate == newValue) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        newValue,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawMetrics#getStartDate() startDate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startDate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withStartDate(Optional<? extends Date> optional) {
    @Nullable Date value = optional.orElse(null);
    if (this.startDate == value) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        value,
        this.resetDate,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RawMetrics#getResetDate() resetDate} attribute.
   * @param value The value for resetDate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withResetDate(Date value) {
    @Nullable Date newValue = Objects.requireNonNull(value, "resetDate");
    if (this.resetDate == newValue) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        newValue,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawMetrics#getResetDate() resetDate} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for resetDate
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withResetDate(Optional<? extends Date> optional) {
    @Nullable Date value = optional.orElse(null);
    if (this.resetDate == value) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        value,
        this.lastProcessed);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RawMetrics#getLastProcessed() lastProcessed} attribute.
   * @param value The value for lastProcessed
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withLastProcessed(Date value) {
    @Nullable Date newValue = Objects.requireNonNull(value, "lastProcessed");
    if (this.lastProcessed == newValue) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        this.resetDate,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RawMetrics#getLastProcessed() lastProcessed} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for lastProcessed
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRawMetrics withLastProcessed(Optional<? extends Date> optional) {
    @Nullable Date value = optional.orElse(null);
    if (this.lastProcessed == value) return this;
    return new ImmutableRawMetrics(
        this.integrationId,
        this.version,
        this.pod,
        this.messages,
        this.errors,
        this.startDate,
        this.resetDate,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRawMetrics} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRawMetrics
        && equalTo((ImmutableRawMetrics) another);
  }

  private boolean equalTo(ImmutableRawMetrics another) {
    return integrationId.equals(another.integrationId)
        && version.equals(another.version)
        && pod.equals(another.pod)
        && messages.equals(another.messages)
        && errors.equals(another.errors)
        && Objects.equals(startDate, another.startDate)
        && Objects.equals(resetDate, another.resetDate)
        && Objects.equals(lastProcessed, another.lastProcessed);
  }

  /**
   * Computes a hash code from attributes: {@code integrationId}, {@code version}, {@code pod}, {@code messages}, {@code errors}, {@code startDate}, {@code resetDate}, {@code lastProcessed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + integrationId.hashCode();
    h += (h << 5) + version.hashCode();
    h += (h << 5) + pod.hashCode();
    h += (h << 5) + messages.hashCode();
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + Objects.hashCode(startDate);
    h += (h << 5) + Objects.hashCode(resetDate);
    h += (h << 5) + Objects.hashCode(lastProcessed);
    return h;
  }

  /**
   * Prints the immutable value {@code RawMetrics} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RawMetrics{");
    builder.append("integrationId=").append(integrationId);
    builder.append(", ");
    builder.append("version=").append(version);
    builder.append(", ");
    builder.append("pod=").append(pod);
    builder.append(", ");
    builder.append("messages=").append(messages);
    builder.append(", ");
    builder.append("errors=").append(errors);
    if (startDate != null) {
      builder.append(", ");
      builder.append("startDate=").append(startDate);
    }
    if (resetDate != null) {
      builder.append(", ");
      builder.append("resetDate=").append(resetDate);
    }
    if (lastProcessed != null) {
      builder.append(", ");
      builder.append("lastProcessed=").append(lastProcessed);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link RawMetrics} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RawMetrics instance
   */
  public static ImmutableRawMetrics copyOf(RawMetrics instance) {
    if (instance instanceof ImmutableRawMetrics) {
      return (ImmutableRawMetrics) instance;
    }
    return new RawMetrics.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableRawMetrics ImmutableRawMetrics}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_INTEGRATION_ID = 0x1L;
    private static final long INIT_BIT_VERSION = 0x2L;
    private static final long INIT_BIT_POD = 0x4L;
    private static final long INIT_BIT_MESSAGES = 0x8L;
    private static final long INIT_BIT_ERRORS = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String integrationId;
    private @Nullable String version;
    private @Nullable String pod;
    private @Nullable Long messages;
    private @Nullable Long errors;
    private @Nullable Date startDate;
    private @Nullable Date resetDate;
    private @Nullable Date lastProcessed;

    /**
     * Creates a builder for {@link ImmutableRawMetrics ImmutableRawMetrics} instances.
     */
    public Builder() {
      if (!(this instanceof RawMetrics.Builder)) {
        throw new UnsupportedOperationException("Use: new RawMetrics.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code RawMetrics} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final RawMetrics.Builder from(RawMetrics instance) {
      Objects.requireNonNull(instance, "instance");
      integrationId(instance.getIntegrationId());
      version(instance.getVersion());
      pod(instance.getPod());
      messages(instance.getMessages());
      errors(instance.getErrors());
      Optional<Date> startDateOptional = instance.getStartDate();
      if (startDateOptional.isPresent()) {
        startDate(startDateOptional);
      }
      Optional<Date> resetDateOptional = instance.getResetDate();
      if (resetDateOptional.isPresent()) {
        resetDate(resetDateOptional);
      }
      Optional<Date> lastProcessedOptional = instance.getLastProcessed();
      if (lastProcessedOptional.isPresent()) {
        lastProcessed(lastProcessedOptional);
      }
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the value for the {@link RawMetrics#getIntegrationId() integrationId} attribute.
     * @param integrationId The value for integrationId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("integrationId")
    public final RawMetrics.Builder integrationId(String integrationId) {
      this.integrationId = Objects.requireNonNull(integrationId, "integrationId");
      initBits &= ~INIT_BIT_INTEGRATION_ID;
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the value for the {@link RawMetrics#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final RawMetrics.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the value for the {@link RawMetrics#getPod() pod} attribute.
     * @param pod The value for pod 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("pod")
    public final RawMetrics.Builder pod(String pod) {
      this.pod = Objects.requireNonNull(pod, "pod");
      initBits &= ~INIT_BIT_POD;
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the value for the {@link RawMetrics#getMessages() messages} attribute.
     * @param messages The value for messages 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("messages")
    public final RawMetrics.Builder messages(Long messages) {
      this.messages = Objects.requireNonNull(messages, "messages");
      initBits &= ~INIT_BIT_MESSAGES;
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the value for the {@link RawMetrics#getErrors() errors} attribute.
     * @param errors The value for errors 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final RawMetrics.Builder errors(Long errors) {
      this.errors = Objects.requireNonNull(errors, "errors");
      initBits &= ~INIT_BIT_ERRORS;
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getStartDate() startDate} to startDate.
     * @param startDate The value for startDate
     * @return {@code this} builder for chained invocation
     */
    public final RawMetrics.Builder startDate(Date startDate) {
      this.startDate = Objects.requireNonNull(startDate, "startDate");
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getStartDate() startDate} to startDate.
     * @param startDate The value for startDate
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("startDate")
    public final RawMetrics.Builder startDate(Optional<? extends Date> startDate) {
      this.startDate = startDate.orElse(null);
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getResetDate() resetDate} to resetDate.
     * @param resetDate The value for resetDate
     * @return {@code this} builder for chained invocation
     */
    public final RawMetrics.Builder resetDate(Date resetDate) {
      this.resetDate = Objects.requireNonNull(resetDate, "resetDate");
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getResetDate() resetDate} to resetDate.
     * @param resetDate The value for resetDate
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resetDate")
    public final RawMetrics.Builder resetDate(Optional<? extends Date> resetDate) {
      this.resetDate = resetDate.orElse(null);
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getLastProcessed() lastProcessed} to lastProcessed.
     * @param lastProcessed The value for lastProcessed
     * @return {@code this} builder for chained invocation
     */
    public final RawMetrics.Builder lastProcessed(Date lastProcessed) {
      this.lastProcessed = Objects.requireNonNull(lastProcessed, "lastProcessed");
      return (RawMetrics.Builder) this;
    }

    /**
     * Initializes the optional value {@link RawMetrics#getLastProcessed() lastProcessed} to lastProcessed.
     * @param lastProcessed The value for lastProcessed
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastProcessed")
    public final RawMetrics.Builder lastProcessed(Optional<? extends Date> lastProcessed) {
      this.lastProcessed = lastProcessed.orElse(null);
      return (RawMetrics.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableRawMetrics ImmutableRawMetrics}.
     * @return An immutable instance of RawMetrics
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRawMetrics build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRawMetrics(integrationId, version, pod, messages, errors, startDate, resetDate, lastProcessed);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_INTEGRATION_ID) != 0) attributes.add("integrationId");
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_POD) != 0) attributes.add("pod");
      if ((initBits & INIT_BIT_MESSAGES) != 0) attributes.add("messages");
      if ((initBits & INIT_BIT_ERRORS) != 0) attributes.add("errors");
      return "Cannot build RawMetrics, some of required attributes are not set " + attributes;
    }
  }
}
