/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImmutableRawMetrics
implements RawMetrics {
    private final String integrationId;
    private final String version;
    private final String pod;
    private final Long messages;
    private final Long errors;
    @Nullable
    private final Date startDate;
    @Nullable
    private final Date resetDate;
    @Nullable
    private final Date lastProcessed;

    private ImmutableRawMetrics(String integrationId, String version, String pod, Long messages, Long errors, @Nullable Date startDate, @Nullable Date resetDate, @Nullable Date lastProcessed) {
        this.integrationId = integrationId;
        this.version = version;
        this.pod = pod;
        this.messages = messages;
        this.errors = errors;
        this.startDate = startDate;
        this.resetDate = resetDate;
        this.lastProcessed = lastProcessed;
    }

    @Override
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    @Override
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="pod")
    public String getPod() {
        return this.pod;
    }

    @Override
    @JsonProperty(value="messages")
    public Long getMessages() {
        return this.messages;
    }

    @Override
    @JsonProperty(value="errors")
    public Long getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="startDate")
    public Optional<Date> getStartDate() {
        return Optional.ofNullable(this.startDate);
    }

    @Override
    @JsonProperty(value="resetDate")
    public Optional<Date> getResetDate() {
        return Optional.ofNullable(this.resetDate);
    }

    @Override
    @JsonProperty(value="lastProcessed")
    public Optional<Date> getLastProcessed() {
        return Optional.ofNullable(this.lastProcessed);
    }

    public final ImmutableRawMetrics withIntegrationId(String value) {
        if (this.integrationId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "integrationId");
        return new ImmutableRawMetrics(newValue, this.version, this.pod, this.messages, this.errors, this.startDate, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withVersion(String value) {
        if (this.version.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "version");
        return new ImmutableRawMetrics(this.integrationId, newValue, this.pod, this.messages, this.errors, this.startDate, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withPod(String value) {
        if (this.pod.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "pod");
        return new ImmutableRawMetrics(this.integrationId, this.version, newValue, this.messages, this.errors, this.startDate, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withMessages(Long value) {
        if (this.messages.equals(value)) {
            return this;
        }
        Long newValue = Objects.requireNonNull(value, "messages");
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, newValue, this.errors, this.startDate, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withErrors(Long value) {
        if (this.errors.equals(value)) {
            return this;
        }
        Long newValue = Objects.requireNonNull(value, "errors");
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, newValue, this.startDate, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withStartDate(Date value) {
        Date newValue = Objects.requireNonNull(value, "startDate");
        if (this.startDate == newValue) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, newValue, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withStartDate(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.startDate == value) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, value, this.resetDate, this.lastProcessed);
    }

    public final ImmutableRawMetrics withResetDate(Date value) {
        Date newValue = Objects.requireNonNull(value, "resetDate");
        if (this.resetDate == newValue) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, this.startDate, newValue, this.lastProcessed);
    }

    public final ImmutableRawMetrics withResetDate(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.resetDate == value) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, this.startDate, value, this.lastProcessed);
    }

    public final ImmutableRawMetrics withLastProcessed(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastProcessed");
        if (this.lastProcessed == newValue) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, this.startDate, this.resetDate, newValue);
    }

    public final ImmutableRawMetrics withLastProcessed(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastProcessed == value) {
            return this;
        }
        return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, this.startDate, this.resetDate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRawMetrics && this.equalTo((ImmutableRawMetrics)another);
    }

    private boolean equalTo(ImmutableRawMetrics another) {
        return this.integrationId.equals(another.integrationId) && this.version.equals(another.version) && this.pod.equals(another.pod) && this.messages.equals(another.messages) && this.errors.equals(another.errors) && Objects.equals(this.startDate, another.startDate) && Objects.equals(this.resetDate, another.resetDate) && Objects.equals(this.lastProcessed, another.lastProcessed);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.integrationId.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.pod.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + Objects.hashCode(this.startDate);
        h += (h << 5) + Objects.hashCode(this.resetDate);
        h += (h << 5) + Objects.hashCode(this.lastProcessed);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RawMetrics{");
        builder.append("integrationId=").append(this.integrationId);
        builder.append(", ");
        builder.append("version=").append(this.version);
        builder.append(", ");
        builder.append("pod=").append(this.pod);
        builder.append(", ");
        builder.append("messages=").append(this.messages);
        builder.append(", ");
        builder.append("errors=").append(this.errors);
        if (this.startDate != null) {
            builder.append(", ");
            builder.append("startDate=").append(this.startDate);
        }
        if (this.resetDate != null) {
            builder.append(", ");
            builder.append("resetDate=").append(this.resetDate);
        }
        if (this.lastProcessed != null) {
            builder.append(", ");
            builder.append("lastProcessed=").append(this.lastProcessed);
        }
        return builder.append("}").toString();
    }

    public static ImmutableRawMetrics copyOf(RawMetrics instance) {
        if (instance instanceof ImmutableRawMetrics) {
            return (ImmutableRawMetrics)instance;
        }
        return new RawMetrics.Builder().from(instance).build();
    }

    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_INTEGRATION_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_POD = 4L;
        private static final long INIT_BIT_MESSAGES = 8L;
        private static final long INIT_BIT_ERRORS = 16L;
        private long initBits = 31L;
        @Nullable
        private String integrationId;
        @Nullable
        private String version;
        @Nullable
        private String pod;
        @Nullable
        private Long messages;
        @Nullable
        private Long errors;
        @Nullable
        private Date startDate;
        @Nullable
        private Date resetDate;
        @Nullable
        private Date lastProcessed;

        public Builder() {
            if (!(this instanceof RawMetrics.Builder)) {
                throw new UnsupportedOperationException("Use: new RawMetrics.Builder()");
            }
        }

        public final RawMetrics.Builder from(RawMetrics instance) {
            Optional<Date> lastProcessedOptional;
            Optional<Date> resetDateOptional;
            Objects.requireNonNull(instance, "instance");
            this.integrationId(instance.getIntegrationId());
            this.version(instance.getVersion());
            this.pod(instance.getPod());
            this.messages(instance.getMessages());
            this.errors(instance.getErrors());
            Optional<Date> startDateOptional = instance.getStartDate();
            if (startDateOptional.isPresent()) {
                this.startDate(startDateOptional);
            }
            if ((resetDateOptional = instance.getResetDate()).isPresent()) {
                this.resetDate(resetDateOptional);
            }
            if ((lastProcessedOptional = instance.getLastProcessed()).isPresent()) {
                this.lastProcessed(lastProcessedOptional);
            }
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="integrationId")
        public final RawMetrics.Builder integrationId(String integrationId) {
            this.integrationId = Objects.requireNonNull(integrationId, "integrationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="version")
        public final RawMetrics.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="pod")
        public final RawMetrics.Builder pod(String pod) {
            this.pod = Objects.requireNonNull(pod, "pod");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="messages")
        public final RawMetrics.Builder messages(Long messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="errors")
        public final RawMetrics.Builder errors(Long errors) {
            this.errors = Objects.requireNonNull(errors, "errors");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (RawMetrics.Builder)this;
        }

        public final RawMetrics.Builder startDate(Date startDate) {
            this.startDate = Objects.requireNonNull(startDate, "startDate");
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="startDate")
        public final RawMetrics.Builder startDate(Optional<? extends Date> startDate) {
            this.startDate = startDate.orElse(null);
            return (RawMetrics.Builder)this;
        }

        public final RawMetrics.Builder resetDate(Date resetDate) {
            this.resetDate = Objects.requireNonNull(resetDate, "resetDate");
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="resetDate")
        public final RawMetrics.Builder resetDate(Optional<? extends Date> resetDate) {
            this.resetDate = resetDate.orElse(null);
            return (RawMetrics.Builder)this;
        }

        public final RawMetrics.Builder lastProcessed(Date lastProcessed) {
            this.lastProcessed = Objects.requireNonNull(lastProcessed, "lastProcessed");
            return (RawMetrics.Builder)this;
        }

        @JsonProperty(value="lastProcessed")
        public final RawMetrics.Builder lastProcessed(Optional<? extends Date> lastProcessed) {
            this.lastProcessed = lastProcessed.orElse(null);
            return (RawMetrics.Builder)this;
        }

        public ImmutableRawMetrics build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRawMetrics(this.integrationId, this.version, this.pod, this.messages, this.errors, this.startDate, this.resetDate, this.lastProcessed);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("integrationId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("pod");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("messages");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("errors");
            }
            return "Cannot build RawMetrics, some of required attributes are not set " + attributes;
        }
    }
}

