/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.syndesis.common.util.SyndesisServerException;
import io.syndesis.server.metrics.jsondb.JolokiaKubernetesAuthenticator;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import io.syndesis.server.metrics.jsondb.RawMetricsHandler;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.management.ObjectName;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.jolokia.client.J4pAuthenticator;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodMetricsReader
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodMetricsReader.class);
    private static final String JOLOKIA_URL_FORMAT = "%sapi/v1/namespaces/%s/pods/https:%s:8778/proxy/jolokia/";
    private static final String ROUTE_ID = "RouteId";
    private static final String START_TIMESTAMP = "StartTimestamp";
    private static final String EXCHANGES_TOTAL = "ExchangesTotal";
    private static final String EXCHANGES_FAILED = "ExchangesFailed";
    private static final String LAST_COMPLETED_TIMESTAMP = "LastExchangeCompletedTimestamp";
    private static final String LAST_FAILED_TIMESTAMP = "LastExchangeFailureTimestamp";
    private static final String RESET_TIMESTAMP = "ResetTimestamp";
    private final J4pClient jolokia;
    private final String integration;
    private final String integrationId;
    private final String version;
    private final String pod;
    private final RawMetricsHandler handler;
    private final Map<String, ObjectName> cache = new HashMap<String, ObjectName>();
    private final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public PodMetricsReader(KubernetesClient kubernetes, String pod, String integration, String integrationId, String version, RawMetricsHandler handler) {
        this.pod = pod;
        this.integration = integration;
        this.integrationId = integrationId;
        this.version = version;
        this.handler = handler;
        this.jolokia = PodMetricsReader.forPod(kubernetes, pod);
    }

    @Override
    public void run() {
        try {
            LOGGER.debug("Collecting stats from integrationId: {}", (Object)this.integrationId);
            List<Map<String, String>> routeStats = this.getRoutes(this.integration, "[a-zA-z0-9_-]+");
            routeStats.forEach(m -> {
                long messages = this.toLong(m.getOrDefault(EXCHANGES_TOTAL, "0"));
                long errors = this.toLong(m.getOrDefault(EXCHANGES_FAILED, "0"));
                Date lastCompleted = this.toDate((String)m.get(LAST_COMPLETED_TIMESTAMP));
                Date lastFailed = this.toDate((String)m.get(LAST_FAILED_TIMESTAMP));
                Date lastMessage = lastCompleted == null && lastFailed != null || lastCompleted != null && lastFailed != null && lastFailed.after(lastCompleted) ? lastFailed : lastCompleted;
                Date resetDate = this.toDate((String)m.get(RESET_TIMESTAMP));
                Date startDate = this.toDate((String)m.get(START_TIMESTAMP));
                this.handler.persist(new RawMetrics.Builder().pod(this.pod).integrationId(this.integrationId).version(this.version).messages(messages).errors(errors).startDate(startDate).lastProcessed(Optional.ofNullable(lastMessage)).resetDate(resetDate).build());
            });
        }
        catch (Exception e) {
            LOGGER.error("Collecting stats from integrationId: {}", (Object)this.integrationId);
        }
    }

    private Long toLong(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private Date toDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            return this.DATE_FORMAT.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private ObjectName lookupCamelContext(String camelContextName) throws Exception {
        ObjectName on = this.cache.get(camelContextName);
        if (on == null) {
            ObjectName found = null;
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest("org.apache.camel:type=context,*"));
            if (sr != null) {
                for (ObjectName name : sr.getObjectNames()) {
                    String id = name.getKeyProperty("name");
                    if (!camelContextName.equals(id = PodMetricsReader.removeLeadingAndEndingQuotes(id))) continue;
                    found = name;
                    break;
                }
            }
            if (found != null) {
                on = found;
                this.cache.put(camelContextName, on);
            }
        }
        return on;
    }

    public List<Map<String, String>> getRoutes(String camelContextName, String filter) throws Exception {
        ObjectName found;
        if (this.jolokia == null) {
            throw new IllegalStateException("Need to connect to remote jolokia first");
        }
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        ObjectName objectName = found = camelContextName != null ? this.lookupCamelContext(camelContextName) : null;
        if (found != null) {
            String pattern = String.format("%s:context=%s,type=routes,*", found.getDomain(), found.getKeyProperty("context"));
            J4pSearchResponse sr = (J4pSearchResponse)this.jolokia.execute((J4pRequest)new J4pSearchRequest(pattern));
            ArrayList<J4pReadRequest> list = new ArrayList<J4pReadRequest>();
            for (ObjectName on : sr.getObjectNames()) {
                list.add(new J4pReadRequest(on, new String[]{ROUTE_ID, RESET_TIMESTAMP, EXCHANGES_TOTAL, EXCHANGES_FAILED, LAST_COMPLETED_TIMESTAMP, LAST_FAILED_TIMESTAMP, START_TIMESTAMP}));
            }
            List lrr = this.jolokia.execute(list);
            for (J4pReadResponse rr : lrr) {
                String routeId = rr.getValue(ROUTE_ID).toString();
                if (filter != null && !routeId.matches(filter)) continue;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                for (String attribute : rr.getAttributes()) {
                    if (rr.getValue(attribute) == null) continue;
                    row.put(attribute, rr.getValue(attribute).toString());
                }
                answer.add(row);
            }
        }
        Collections.sort(answer, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String c2;
                String c1 = o1.get("camelContextName");
                int answer = c1.compareTo(c2 = o2.get("camelContextName"));
                if (answer == 0) {
                    answer = o1.get("routeId").compareTo(o2.get("routeId"));
                }
                return answer;
            }
        });
        return answer;
    }

    private static J4pClient forPod(KubernetesClient kubernetes, String pod) {
        String jolokiaUrl = String.format(JOLOKIA_URL_FORMAT, kubernetes.getMasterUrl(), kubernetes.getNamespace(), pod);
        try {
            return new J4pClientBuilder().url(jolokiaUrl).user("user").authenticator((J4pAuthenticator)new JolokiaKubernetesAuthenticator(kubernetes)).sslConnectionSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(SSLUtils.sslContext((Config)kubernetes.getConfiguration()))).build();
        }
        catch (Exception e) {
            throw SyndesisServerException.launderThrowable((Throwable)e);
        }
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (PodMetricsReader.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isEmpty(Object value) {
        return !PodMetricsReader.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Map) {
            return !((Map)value).isEmpty();
        }
        return true;
    }
}

