/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import com.fasterxml.jackson.core.type.TypeReference;
import io.syndesis.common.model.WithId;
import io.syndesis.common.model.metrics.IntegrationMetricsSummary;
import io.syndesis.common.util.Json;
import io.syndesis.common.util.cache.CacheManager;
import io.syndesis.common.util.cache.LRUCacheManager;
import io.syndesis.server.dao.manager.DataManager;
import io.syndesis.server.dao.manager.EncryptionComponent;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.jsondb.impl.Index;
import io.syndesis.server.jsondb.impl.SqlJsonDB;
import io.syndesis.server.metrics.jsondb.IntegrationMetricsHandler;
import io.syndesis.server.metrics.jsondb.JsonDBRawMetrics;
import io.syndesis.server.metrics.jsondb.MetricsCollector;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class MetricsCollectorTest {
    private SqlJsonDB jsondb;
    private DataManager dataManager;
    private JsonDBRawMetrics jsondbRM;
    private IntegrationMetricsHandler intMH;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-M-yyyy hh:mm:ss");

    @Before
    public void before() throws IOException, ParseException {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;MODE=PostgreSQL");
        DBI dbi = new DBI((DataSource)ds);
        this.jsondb = new SqlJsonDB(dbi, null, Arrays.asList(new Index("/pair", "key")));
        try {
            this.jsondb.dropTables();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jsondb.createTables();
        this.jsondbRM = new JsonDBRawMetrics((JsonDB)this.jsondb);
        this.load();
        LRUCacheManager cacheManager = new LRUCacheManager(100);
        EncryptionComponent encryptionComponent = new EncryptionComponent(null);
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        this.dataManager = new DataManager((CacheManager)cacheManager, Collections.emptyList(), null, encryptionComponent, (ResourceLoader)resourceLoader);
        this.intMH = new IntegrationMetricsHandler(this.dataManager);
    }

    private void load() throws IOException, ParseException {
        this.jsondbRM.persist(this.raw("intId1", "1", "pod1", 3L, "31-01-2018 10:20:56"));
        this.jsondbRM.persist(this.raw("intId1", "1", "pod2", 3L, "31-01-2018 10:22:56"));
        this.jsondbRM.persist(this.raw("intId1", "1", "HISTORY1", 3L, "22-01-2015 10:20:56"));
        this.jsondbRM.persist(this.raw("intId2", "1", "pod3", 3L, "31-01-2018 10:20:56"));
        this.jsondbRM.persist(this.raw("intId3", "1", "pod4", 3L, "31-01-2018 10:20:56"));
        this.jsondbRM.persist(this.raw("intId3", "1", "pod5", 3L, "31-01-2018 10:20:56"));
    }

    private RawMetrics raw(String integrationId, String version, String podName, Long messages, String startDateString) throws ParseException {
        Date startDate = this.sdf.parse(startDateString);
        return new RawMetrics.Builder().integrationId(integrationId).version(version).pod(podName).messages(messages).errors(Long.valueOf(1L)).startDate(startDate).resetDate(Optional.empty()).lastProcessed(new Date()).build();
    }

    @Test
    public void testGetMetricsForIntegration1() throws IOException {
        String json = this.jsondb.getAsString(JsonDBRawMetrics.path((String)"intId1"), new GetOptions().prettyPrint(true));
        Map metrics = (Map)Json.reader().forType((TypeReference)new TypeReference<Map<String, RawMetrics>>(){}).readValue(json);
        Assertions.assertThat((int)metrics.size()).isEqualTo(3);
        Assertions.assertThat(metrics.keySet()).contains((Object[])new String[]{"HISTORY1"});
    }

    @Test
    public void testGetRawMetrics() throws IOException {
        MetricsCollector collector = new MetricsCollector(null, (JsonDB)this.jsondb, null);
        Map metrics = this.jsondbRM.getRawMetrics("intId1");
        Assertions.assertThat((int)metrics.size()).isEqualTo(3);
        Assertions.assertThat(metrics.keySet()).contains((Object[])new String[]{"HISTORY1"});
        HashSet<String> livePodIds = new HashSet<String>(Arrays.asList("pod1"));
        this.jsondbRM.curate("intId1", metrics, livePodIds);
        Map metrics2 = this.jsondbRM.getRawMetrics("intId1");
        Assertions.assertThat((int)metrics2.size()).isEqualTo(2);
        Assertions.assertThat(metrics2.keySet()).contains((Object[])new String[]{"HISTORY1"});
        collector.close();
    }

    @Test
    public void testGetIntegrationSummary() throws IOException, ParseException {
        String integrationId = "intId1";
        HashSet<String> livePodIds = new HashSet<String>(Arrays.asList("pod1", "pod2", "pod3", "pod4", "pod5"));
        MetricsCollector collector = new MetricsCollector(null, (JsonDB)this.jsondb, null);
        Map metrics = this.jsondbRM.getRawMetrics(integrationId);
        IntegrationMetricsSummary summary = this.intMH.compute(integrationId, metrics, livePodIds);
        Assertions.assertThat((Long)summary.getMessages()).isEqualTo(9L);
        Assertions.assertThat((Long)summary.getErrors()).isEqualTo(3L);
        Assertions.assertThat((Date)((Date)summary.getStart().get())).isEqualTo((Object)this.sdf.parse("31-01-2018 10:20:56"));
        this.jsondb.update(JsonDBRawMetrics.path((String)"intId1", (String)"pod2"), Json.writer().writeValueAsString((Object)this.raw("intId1", "2", "pod2", 9L, "31-01-2018 10:22:56")));
        Map updatedMetrics = this.jsondbRM.getRawMetrics(integrationId);
        IntegrationMetricsSummary updatedSummary = this.intMH.compute(integrationId, updatedMetrics, livePodIds);
        Assertions.assertThat((Long)updatedSummary.getMessages()).isEqualTo(15L);
        Assertions.assertThat((Long)updatedSummary.getErrors()).isEqualTo(3L);
        collector.close();
    }

    @Test
    public void testDeadPodCurator() throws IOException, ParseException {
        String integrationId = "intId1";
        MetricsCollector collector = new MetricsCollector(null, (JsonDB)this.jsondb, null);
        HashSet<String> livePodIds = new HashSet<String>(Arrays.asList("pod2", "pod3", "pod4", "pod5"));
        this.jsondb.update(JsonDBRawMetrics.path((String)"intId1", (String)"pod1"), Json.writer().writeValueAsString((Object)this.raw("intId1", "1", "pod1", 12L, "31-01-2018 10:22:56")));
        Map metrics = this.jsondbRM.getRawMetrics(integrationId);
        IntegrationMetricsSummary summary = this.intMH.compute(integrationId, metrics, livePodIds);
        Assertions.assertThat((Long)summary.getMessages()).isEqualTo(18L);
        Assertions.assertThat((Long)summary.getErrors()).isEqualTo(3L);
        Assertions.assertThat((Date)((Date)summary.getStart().get())).isEqualTo((Object)this.sdf.parse("31-01-2018 10:22:56"));
        collector.close();
    }

    @Test
    public void testDeletedIntegrationsCurator() throws IOException, ParseException {
        String integrationId = "intId1";
        HashSet<String> livePodIds = new HashSet<String>(Arrays.asList("pod1", "pod2"));
        Map metrics = this.jsondbRM.getRawMetrics(integrationId);
        IntegrationMetricsSummary summary = this.intMH.compute(integrationId, metrics, livePodIds);
        this.dataManager.create((WithId)summary);
        Assertions.assertThat((int)metrics.size()).isEqualTo(3);
        Assertions.assertThat((int)this.dataManager.fetchAll(IntegrationMetricsSummary.class).getTotalCount()).isEqualTo(1);
        this.jsondbRM.curate(new HashSet());
        this.intMH.curate(new HashSet());
        Map metricsAfter = this.jsondbRM.getRawMetrics(integrationId);
        Assertions.assertThat((int)metricsAfter.size()).isEqualTo(0);
        Assertions.assertThat((int)this.dataManager.fetchAll(IntegrationMetricsSummary.class).getTotalCount()).isEqualTo(0);
    }
}

