/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import io.syndesis.common.model.WithId;
import io.syndesis.common.model.metrics.IntegrationDeploymentMetrics;
import io.syndesis.common.model.metrics.IntegrationMetricsSummary;
import io.syndesis.server.dao.manager.DataManager;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IntegrationMetricsHandler {
    private final DataManager dataManager;

    IntegrationMetricsHandler(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public void persist(IntegrationMetricsSummary currentSummary) {
        IntegrationMetricsSummary existingSummary = (IntegrationMetricsSummary)this.dataManager.fetch(IntegrationMetricsSummary.class, (String)currentSummary.getId().get());
        if (existingSummary == null) {
            this.dataManager.create((WithId)currentSummary);
        } else if (!existingSummary.equals(currentSummary)) {
            this.dataManager.update((WithId)currentSummary);
        }
    }

    public void curate(Set<String> activeIntegrationIds) {
        Set summaryIds = this.dataManager.fetchIds(IntegrationMetricsSummary.class);
        for (String summaryId : summaryIds) {
            if (activeIntegrationIds.contains(summaryId)) continue;
            this.dataManager.delete(IntegrationMetricsSummary.class, summaryId);
        }
    }

    public IntegrationMetricsSummary compute(String integrationId, Map<String, RawMetrics> metrics, Set<String> livePodIds) {
        HashMap<String, Metrics> m = new HashMap<String, Metrics>();
        Metrics tm = new Metrics();
        for (RawMetrics raw : metrics.values()) {
            String version = raw.getVersion();
            Metrics mh = m.containsKey(version) ? (Metrics)m.get(version) : new Metrics();
            mh.add(livePodIds, raw);
            m.put(version, mh);
            tm = tm.add(livePodIds, raw);
        }
        ArrayList<IntegrationDeploymentMetrics> dmList = new ArrayList<IntegrationDeploymentMetrics>();
        for (Metrics mh : m.values()) {
            IntegrationDeploymentMetrics dm = new IntegrationDeploymentMetrics.Builder().version(mh.getVersion()).messages(mh.getMessages()).errors(mh.getErrors()).start(mh.getStartDate()).lastProcessed(mh.getLastProcessed()).build();
            dmList.add(dm);
        }
        return new IntegrationMetricsSummary.Builder().id(integrationId).messages(tm.getMessages()).errors(tm.getErrors()).start(tm.getStartDate()).lastProcessed(tm.getLastProcessed()).integrationDeploymentMetrics(dmList).build();
    }

    static class Metrics {
        private Long messages = 0L;
        private Long errors = 0L;
        private Optional<Date> lastProcessed = Optional.empty();
        private Optional<Date> startDate = Optional.empty();
        private String version;

        public Metrics add(Set<String> livePodIds, RawMetrics raw) {
            this.version = raw.getVersion();
            this.messages = this.messages + raw.getMessages();
            this.errors = this.errors + raw.getErrors();
            if (livePodIds.contains(raw.getPod())) {
                if (this.startDate.isPresent()) {
                    if (raw.getStartDate().get().before(this.startDate.get())) {
                        this.setStartDate(raw.getStartDate());
                    }
                } else {
                    this.setStartDate(raw.getStartDate());
                }
            }
            if (raw.getLastProcessed().isPresent()) {
                if (this.getLastProcessed().isPresent()) {
                    this.setLastProcessed(raw.getLastProcessed().get().after(this.getLastProcessed().get()) ? raw.getLastProcessed() : this.getLastProcessed());
                } else {
                    this.setLastProcessed(raw.getLastProcessed());
                }
            }
            return this;
        }

        public Long getMessages() {
            return this.messages;
        }

        public Long getErrors() {
            return this.errors;
        }

        public Optional<Date> getLastProcessed() {
            return this.lastProcessed;
        }

        public Optional<Date> getStartDate() {
            return this.startDate;
        }

        public String getVersion() {
            return this.version;
        }

        public void setMessages(Long messages) {
            this.messages = messages;
        }

        public void setErrors(Long errors) {
            this.errors = errors;
        }

        public void setLastProcessed(Optional<Date> lastProcessed) {
            this.lastProcessed = lastProcessed;
        }

        public void setStartDate(Optional<Date> startDate) {
            this.startDate = startDate;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metrics)) {
                return false;
            }
            Metrics other = (Metrics)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$messages = this.getMessages();
            Long other$messages = other.getMessages();
            if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
                return false;
            }
            Long this$errors = this.getErrors();
            Long other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            Optional<Date> this$lastProcessed = this.getLastProcessed();
            Optional<Date> other$lastProcessed = other.getLastProcessed();
            if (this$lastProcessed == null ? other$lastProcessed != null : !((Object)this$lastProcessed).equals(other$lastProcessed)) {
                return false;
            }
            Optional<Date> this$startDate = this.getStartDate();
            Optional<Date> other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Metrics;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            Long $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            Optional<Date> $lastProcessed = this.getLastProcessed();
            result = result * 59 + ($lastProcessed == null ? 43 : ((Object)$lastProcessed).hashCode());
            Optional<Date> $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "IntegrationMetricsHandler.Metrics(messages=" + this.getMessages() + ", errors=" + this.getErrors() + ", lastProcessed=" + this.getLastProcessed() + ", startDate=" + this.getStartDate() + ", version=" + this.getVersion() + ")";
        }
    }
}

