/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.server.metrics.jsondb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.syndesis.common.util.Json;
import io.syndesis.server.jsondb.GetOptions;
import io.syndesis.server.jsondb.JsonDB;
import io.syndesis.server.metrics.jsondb.ImmutableRawMetrics;
import io.syndesis.server.metrics.jsondb.RawMetrics;
import io.syndesis.server.metrics.jsondb.RawMetricsHandler;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDBRawMetrics
implements RawMetricsHandler {
    private static final String HISTORY = "HISTORY";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonDBRawMetrics.class);
    public static final TypeReference<Map<String, Boolean>> TYPE_REFERENCE = new TypeReference<Map<String, Boolean>>(){};
    public static final TypeReference<Map<String, RawMetrics>> VALUE_TYPE_REF = new TypeReference<Map<String, RawMetrics>>(){};
    private final JsonDB jsonDB;

    public JsonDBRawMetrics(JsonDB jsonDB) {
        this.jsonDB = jsonDB;
    }

    @Override
    public void persist(RawMetrics rawMetrics) {
        try {
            String path = JsonDBRawMetrics.path(rawMetrics.getIntegrationId(), rawMetrics.getPod());
            String json = Json.writer().writeValueAsString((Object)rawMetrics);
            if (this.jsonDB.exists(path)) {
                if (!this.jsonDB.getAsString(path).equals(json)) {
                    this.jsonDB.update(path, json);
                }
            } else {
                this.jsonDB.set(path, json);
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error persisting metrics!", (Throwable)e);
        }
    }

    @Override
    public Map<String, RawMetrics> getRawMetrics(String integrationId) throws IOException {
        Map<String, RawMetrics> metrics = new HashMap<String, RawMetrics>();
        String path = JsonDBRawMetrics.path(integrationId);
        String json = this.jsonDB.getAsString(path);
        if (json != null) {
            metrics = (Map)Json.reader().forType(VALUE_TYPE_REF).readValue(json);
        }
        return metrics;
    }

    @Override
    public void curate(String integrationId, Map<String, RawMetrics> metrics, Set<String> livePodIds) throws IOException {
        for (Map.Entry<String, RawMetrics> entry : metrics.entrySet()) {
            String historyKey = HISTORY + entry.getValue().getVersion();
            if (entry.getKey().contains(historyKey) || livePodIds.contains(entry.getKey())) continue;
            if (metrics.containsKey(historyKey)) {
                RawMetrics history = metrics.get(historyKey);
                RawMetrics dead = entry.getValue();
                Date lastProcessed = history.getLastProcessed().orElse(new Date(0L)).after(dead.getLastProcessed().orElse(new Date(0L))) ? (Date)history.getLastProcessed().orElse(null) : (Date)dead.getLastProcessed().orElse(null);
                ImmutableRawMetrics updatedHistoryMetrics = new RawMetrics.Builder().integrationId(integrationId).version(dead.getVersion()).pod(history.getIntegrationId() + ":" + dead.getPod()).messages(history.getMessages() + dead.getMessages()).errors(history.getErrors() + dead.getErrors()).startDate(Optional.empty()).resetDate(Optional.empty()).lastProcessed(Optional.ofNullable(lastProcessed)).build();
                String json = Json.writer().writeValueAsString((Object)updatedHistoryMetrics);
                this.jsonDB.update(JsonDBRawMetrics.path(integrationId, historyKey), json);
            } else {
                String json = Json.writer().writeValueAsString((Object)metrics.get(entry.getKey()));
                this.jsonDB.set(JsonDBRawMetrics.path(integrationId, historyKey), json);
            }
            this.jsonDB.delete(JsonDBRawMetrics.path(integrationId, entry.getKey()));
        }
    }

    @Override
    public void curate(Set<String> activeIntegrationIds) throws IOException, JsonMappingException {
        String json = this.jsonDB.getAsString(JsonDBRawMetrics.path(), new GetOptions().depth(Integer.valueOf(1)));
        if (json != null) {
            Map metricsMap = (Map)Json.reader().forType(TYPE_REFERENCE).readValue(json);
            Set rawIntegrationIds = metricsMap.keySet();
            for (String rawIntId : rawIntegrationIds) {
                if (activeIntegrationIds.contains(rawIntId)) continue;
                this.jsonDB.delete(JsonDBRawMetrics.path(rawIntId));
            }
        }
    }

    static String path(String integrationId, String podName) {
        return String.format("%s/integrations/%s/pods/%s", RawMetrics.class.getSimpleName(), integrationId, podName);
    }

    static String path(String integrationId) {
        return String.format("%s/integrations/%s/pods", RawMetrics.class.getSimpleName(), integrationId);
    }

    static String path() {
        return String.format("%s/integrations", RawMetrics.class.getSimpleName());
    }
}

