/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql.stored;

import io.syndesis.connector.sql.SqlConnectorVerifierExtension;
import io.syndesis.connector.sql.stored.JSONBeanUtil;
import io.syndesis.connector.sql.stored.SqlStoredConnectorMetaDataExtension;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.connector.DefaultConnectorComponent;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlStoredStartConnectorComponent
extends DefaultConnectorComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlStoredStartConnectorComponent.class);
    static final String COMPONENT_NAME = "sql-stored-start-connector";
    static final String COMPONENT_SCHEME = "sql-stored-start-connector";

    public SqlStoredStartConnectorComponent() {
        this(null);
    }

    public SqlStoredStartConnectorComponent(String componentSchema) {
        super("sql-stored-start-connector", componentSchema, SqlStoredStartConnectorComponent.class.getName());
        this.registerExtension((ComponentExtension)new SqlConnectorVerifierExtension("sql-stored-start-connector"));
        this.registerExtension(SqlStoredConnectorMetaDataExtension::new);
    }

    public Processor getAfterProducer() {
        Processor processor = exchange -> {
            String jsonBean = JSONBeanUtil.toJSONBean((Map)((Map)exchange.getIn().getBody(Map.class)));
            exchange.getIn().setBody((Object)jsonBean);
        };
        return processor;
    }

    protected void doStart() throws Exception {
        Map options = this.getOptions();
        if (!options.containsKey("dataSource")) {
            if (options.containsKey("user") && options.containsKey("password") && options.containsKey("url")) {
                BasicDataSource ds = new BasicDataSource();
                this.consumeOption("user", String.class, arg_0 -> ((BasicDataSource)ds).setUsername(arg_0));
                this.consumeOption("password", String.class, arg_0 -> ((BasicDataSource)ds).setPassword(arg_0));
                this.consumeOption("url", String.class, arg_0 -> ((BasicDataSource)ds).setUrl(arg_0));
                this.addOption("dataSource", ds);
            } else {
                LOGGER.debug("Not enough information provided to set-up the DataSource");
            }
        }
        super.doStart();
    }

    private <T> void consumeOption(String name, Class<T> type, Consumer<T> consumer) throws NoTypeConversionAvailableException {
        TypeConverter converter = this.getCamelContext().getTypeConverter();
        Object val = this.getOptions().get(name);
        Object result = converter.mandatoryConvertTo(type, val);
        consumer.accept(result);
        LOGGER.debug("Consume option {}", (Object)name);
        this.getOptions().remove(name);
    }
}

