/*
 * Decompiled with CFR 0.152.
 */
package io.taig.flog.stackdriver.http;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Show$;
import cats.UnorderedFoldable$;
import cats.effect.Blocker$;
import cats.effect.Clock;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.logging.v2.Logging;
import com.google.api.services.logging.v2.model.LogEntry;
import com.google.api.services.logging.v2.model.MonitoredResource;
import com.google.api.services.logging.v2.model.WriteLogEntriesRequest;
import com.google.api.services.logging.v2.model.WriteLogEntriesResponse;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.ServiceAccountCredentials;
import io.taig.flog.Encoder;
import io.taig.flog.Encoder$;
import io.taig.flog.Logger;
import io.taig.flog.Logger$;
import io.taig.flog.data.Event;
import io.taig.flog.data.Level;
import io.taig.flog.data.Payload$;
import io.taig.flog.data.Scope$;
import io.taig.flog.syntax;
import io.taig.flog.syntax$;
import io.taig.flog.util.StacktracePrinter$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class StackdriverHttpLogger$ {
    public static final StackdriverHttpLogger$ MODULE$ = new StackdriverHttpLogger$();
    private static final Function1<Level, String> severity = (Function1 & Serializable)x0$1 -> {
        String string;
        Level level = x0$1;
        if (Level.Debug$.MODULE$.equals(level)) {
            string = "DEBUG";
        } else if (Level.Error$.MODULE$.equals(level)) {
            string = "ERROR";
        } else if (Level.Info$.MODULE$.equals(level)) {
            string = "INFO";
        } else if (Level.Warning$.MODULE$.equals(level)) {
            string = "WARNING";
        } else {
            throw new MatchError((Object)level);
        }
        return string;
    };
    private static volatile boolean bitmap$init$0 = true;

    public <F> Logger<F> apply(ExecutionContext blocker, Logging.Entries logging, String project, String name, MonitoredResource resource, ContextShift<F> evidence$1, Clock<F> evidence$2, Sync<F> F) {
        return Logger$.MODULE$.apply((Function1 & Serializable)events -> ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toTraverseOps(events, UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)x$1 -> MODULE$.entry(project, name, (Event)x$1, resource, F), (Applicative)F), (FlatMap)F).flatMap((Function1 & Serializable)entries -> {
            WriteLogEntriesRequest request = new WriteLogEntriesRequest().setEntries(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)entries).asJava());
            return package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> (WriteLogEntriesResponse)logging.write(request).execute(), F, evidence$1), (Functor)F).void();
        }), (ApplicativeError)F), (Function1 & Serializable)throwable -> package.all$.MODULE$.toFlatMapOps(MODULE$.failureEntry(project, name, resource, (Throwable)throwable, F), (FlatMap)F).flatMap((Function1 & Serializable)entry -> {
            WriteLogEntriesRequest request = new WriteLogEntriesRequest().setEntries(Arrays.asList((Object[])new LogEntry[]{entry}));
            return package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> (WriteLogEntriesResponse)logging.write(request).execute(), F, evidence$1), (Functor)F).void();
        }), (ApplicativeError)F), (ApplicativeError)F), (Function1 & Serializable)throwable -> F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> throwable.printStackTrace(System.err)), (ApplicativeError)F), F, evidence$2);
    }

    public <F> Resource<F, Logger<F>> fromCredentials(ExecutionContext blocker, Credentials credentials, String project, String name, MonitoredResource resource, Sync<F> evidence$3, ContextShift<F> evidence$4, Clock<F> evidence$5) {
        return Resource$.MODULE$.make(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> GoogleNetHttpTransport.newTrustedTransport(), evidence$3, evidence$4), (Function1 & Serializable)transport -> Blocker$.MODULE$.delay$extension(blocker, (Function0)(JFunction0.mcV.sp & Serializable)() -> transport.shutdown(), evidence$3, evidence$4), evidence$3).evalMap((Function1 & Serializable)transport -> Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> {
            Logging logging = new Logging.Builder((HttpTransport)transport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new HttpCredentialsAdapter(credentials)).setApplicationName(project).build();
            return MODULE$.apply(blocker, logging.entries(), project, name, resource, evidence$4, evidence$5, evidence$3);
        }, evidence$3, evidence$4), evidence$3);
    }

    public <F> Resource<F, Logger<F>> fromServiceAccount(ExecutionContext blocker, InputStream account, String project, String name, MonitoredResource resource, Sync<F> evidence$6, ContextShift<F> evidence$7, Clock<F> evidence$8) {
        return Resource$.MODULE$.liftF(Blocker$.MODULE$.delay$extension(blocker, (Function0 & Serializable)() -> {
            java.util.List<Object> scopes = Arrays.asList((Object[])new String[]{"https://www.googleapis.com/auth/cloud-platform.read-only", "https://www.googleapis.com/auth/logging.write"});
            return ServiceAccountCredentials.fromStream((InputStream)account).createScoped(scopes);
        }, evidence$6, evidence$7), evidence$6).flatMap((Function1 & Serializable)x$2 -> MODULE$.fromCredentials(blocker, (Credentials)x$2, project, name, resource, evidence$6, evidence$7, evidence$8));
    }

    private <F> F id(Sync<F> F) {
        return (F)F.delay((Function0 & Serializable)() -> package.all$.MODULE$.toShow((Object)UUID.randomUUID(), Show$.MODULE$.catsShowForUUID()).show());
    }

    private <F> F entry(String project, String name, Event event, MonitoredResource resource, Sync<F> evidence$9) {
        return (F)package.all$.MODULE$.toFunctorOps(this.id(evidence$9), evidence$9).map((Function1 & Serializable)id -> new LogEntry().setJsonPayload(MODULE$.payload(event)).setLogName(MODULE$.logName(project, name, event.scope())).setInsertId(id).setSeverity((String)MODULE$.severity().apply((Object)event.level())).setResource(resource).setTimestamp(Instant.ofEpochMilli(event.timestamp()).toString()));
    }

    private <F> F failureEntry(String project, String name, MonitoredResource resource, Throwable throwable, Sync<F> evidence$10) {
        return (F)package.all$.MODULE$.toFunctorOps(this.id(evidence$10), evidence$10).map((Function1 & Serializable)id -> {
            Map<String, String> payload = Map.of("message", "Failed to submit events", "stacktrace", StacktracePrinter$.MODULE$.apply(throwable));
            return new LogEntry().setJsonPayload(payload).setLogName(MODULE$.logName(project, name, Scope$.MODULE$.Root())).setInsertId(id).setSeverity((String)MODULE$.severity().apply((Object)Level.Error$.MODULE$)).setResource(resource);
        });
    }

    public String logName(String project, String name, List scope) {
        String string = name;
        return new StringBuilder(0).append(new StringBuilder(15).append("projects/").append(project).append("/logs/").toString()).append(URLEncoder.encode(((IterableOnceOps)scope.$plus$colon((Object)string)).mkString("."), StandardCharsets.UTF_8)).toString();
    }

    private Map<String, Object> payload(Event event) {
        return Payload$.MODULE$.of((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{syntax.PayloadStringOps$.MODULE$.$colon$eq$extension(syntax$.MODULE$.PayloadStringOps("message"), (Object)Option$.MODULE$.apply((Object)event.message()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3)))), Encoder$.MODULE$.option(Encoder$.MODULE$.string())), syntax.PayloadStringOps$.MODULE$.$colon$eq$extension(syntax$.MODULE$.PayloadStringOps("payload"), (Object)event.payload(), Encoder$.MODULE$.obj(Encoder.Object$.MODULE$.obj())), syntax.PayloadStringOps$.MODULE$.$colon$eq$extension(syntax$.MODULE$.PayloadStringOps("stacktrace"), (Object)event.throwable().map((Function1 & Serializable)x$4 -> StacktracePrinter$.MODULE$.apply(x$4)), Encoder$.MODULE$.option(Encoder$.MODULE$.string()))})).toJavaMap();
    }

    private Function1<Level, String> severity() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /builds/taig-github/flog/modules/stackdriver-http/src/main/scala/io/taig/flog/stackdriver/http/StackdriverHttpLogger.scala: 140");
        }
        return severity;
    }

    private StackdriverHttpLogger$() {
    }
}

