/*
 * Decompiled with CFR 0.152.
 */
package io.taig.taigless.registry;

import cats.Applicative;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Functor$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.effect.std.Semaphore;
import cats.implicits$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import fs2.concurrent.SignallingRef;
import io.taig.taigless.registry.InMemoryRegistry;
import io.taig.taigless.registry.InMemoryRegistry$State$Idle$;
import io.taig.taigless.registry.InMemoryRegistry$State$Loading$;
import io.taig.taigless.registry.InMemoryRegistry$State$Ready$;
import io.taig.taigless.registry.InMemoryRegistry$State$Removed$;
import io.taig.taigless.registry.InMemoryStore$;
import io.taig.taigless.registry.Store;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class InMemoryStore<F, A, B>
extends Store<F, A, B> {
    private final Semaphore<F> lock;
    private final InMemoryRegistry<F, A, B> registry;
    private final Sync<F> F;
    private final Object available;
    private final Object size;
    private final Object clear;

    public static <F, A, B> Object empty(Async<F> async) {
        return InMemoryStore$.MODULE$.empty(async);
    }

    public static <F, A, B> Object of(Map<A, B> map, Async<F> async) {
        return InMemoryStore$.MODULE$.of(map, async);
    }

    public InMemoryStore(Semaphore<F> lock, InMemoryRegistry<F, A, B> registry, Sync<F> F) {
        this.lock = lock;
        this.registry = registry;
        this.F = F;
        this.available = lock.permit().surround(implicits$.MODULE$.toFoldableOps((Object)registry.store().values().toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).foldLeftM((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(available, signal) -> InMemoryStore.$init$$$anonfun$5(F, BoxesRunTime.unboxToInt((Object)available), (SignallingRef)signal), F), F);
        this.size = lock.permit().surround(implicits$.MODULE$.toFoldableOps((Object)registry.store().values().toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).foldLeftM((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(available, signal) -> InMemoryStore.$init$$$anonfun$7(F, BoxesRunTime.unboxToInt((Object)available), (SignallingRef)signal), F), F);
        this.clear = lock.permit().surround(implicits$.MODULE$.catsSyntaxApply(implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseFilterOps((Object)registry.store().toList(), implicits$.MODULE$.catsStdTraverseFilterForList()).traverseFilter((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            SignallingRef signal = (SignallingRef)tuple2._2();
            return implicits$.MODULE$.toFlatMapOps(signal.get(), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                Object object;
                InMemoryRegistry.State state = x$1;
                if (state instanceof InMemoryRegistry.State.Loading) {
                    Object f;
                    InMemoryRegistry.State.Loading loading = InMemoryRegistry$State$Loading$.MODULE$.unapply((InMemoryRegistry.State.Loading)state);
                    Object cancel = f = loading._1();
                    object = Functor$.MODULE$.apply((Functor)F).as(cancel, (Object)implicits$.MODULE$.none());
                } else if (state instanceof InMemoryRegistry.State.Ready) {
                    Object a;
                    InMemoryRegistry.State.Ready ready = InMemoryRegistry$State$Ready$.MODULE$.unapply((InMemoryRegistry.State.Ready)state);
                    Object value = a = ready._1();
                    Tuple2 tuple2 = (Tuple2)implicits$.MODULE$.catsSyntaxOptionId((Object)Tuple2$.MODULE$.apply(key, value));
                    Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)OptionIdOps$.MODULE$.some$extension((Object)tuple2));
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)F);
                } else if (InMemoryRegistry$State$Removed$.MODULE$.equals(state) || state instanceof InMemoryRegistry.State.Failed || InMemoryRegistry$State$Idle$.MODULE$.equals(state)) {
                    Option option = (Option)implicits$.MODULE$.catsSyntaxApplicativeId((Object)implicits$.MODULE$.none());
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)F);
                } else {
                    throw new MatchError((Object)state);
                }
                return object;
            });
        }, F), F).map((Function1 & Serializable)_$2 -> _$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), F).$less$times(F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> InMemoryStore.$init$$$anonfun$3(registry)))), F);
    }

    public F available() {
        return (F)this.available;
    }

    public F size() {
        return (F)this.size;
    }

    public F clear() {
        return (F)this.clear;
    }

    public F get(A key) {
        return (F)this.lock.permit().surround(this.registry.get(key), this.F);
    }

    public F tryGet(A key) {
        return (F)this.lock.permit().surround(this.registry.tryGet(key), this.F);
    }

    public F getOrInsert(A key, Function0<F> fallback) {
        return (F)this.lock.permit().surround(this.registry.getOrInsert(key, fallback), this.F);
    }

    public F insert(A key, B value) {
        return (F)this.lock.permit().surround(this.registry.insert(key, value), this.F);
    }

    public F remove(A key) {
        return (F)this.lock.permit().surround(this.registry.remove(key), this.F);
    }

    private static final /* synthetic */ Object $init$$$anonfun$5(Sync F$4, int available, SignallingRef signal) {
        return implicits$.MODULE$.toFunctorOps(signal.get(), (Functor)F$4).map((Function1 & Serializable)x$1 -> {
            int n;
            InMemoryRegistry.State state = x$1;
            if (state instanceof InMemoryRegistry.State.Ready) {
                n = available + 1;
            } else if (state instanceof InMemoryRegistry.State.Loading || InMemoryRegistry$State$Removed$.MODULE$.equals(state) || state instanceof InMemoryRegistry.State.Failed || InMemoryRegistry$State$Idle$.MODULE$.equals(state)) {
                n = available;
            } else {
                throw new MatchError((Object)state);
            }
            return n;
        });
    }

    private static final /* synthetic */ Object $init$$$anonfun$7(Sync F$5, int available, SignallingRef signal) {
        return implicits$.MODULE$.toFunctorOps(signal.get(), (Functor)F$5).map((Function1 & Serializable)x$1 -> {
            int n;
            InMemoryRegistry.State state = x$1;
            if (state instanceof InMemoryRegistry.State.Ready || state instanceof InMemoryRegistry.State.Loading || InMemoryRegistry$State$Idle$.MODULE$.equals(state)) {
                n = available + 1;
            } else if (InMemoryRegistry$State$Removed$.MODULE$.equals(state) || state instanceof InMemoryRegistry.State.Failed) {
                n = available;
            } else {
                throw new MatchError((Object)state);
            }
            return n;
        });
    }

    private static final void $init$$$anonfun$3(InMemoryRegistry registry$1) {
        registry$1.store().clear();
    }
}

