package io.taig.taigless.scheduler

import scala.util.control.NoStackTrace

abstract class Scheduler[F[_]] {
  def create(job: Scheduler.Job): F[Either[Scheduler.CreateError, Scheduler.Job]]

  def list: F[List[Scheduler.Job]]

  def resume(name: Scheduler.Job.Name): F[Boolean]

  def pause(name: Scheduler.Job.Name): F[Boolean]

  def delete(name: Scheduler.Job.Name): F[Boolean]

  def patch(name: Scheduler.Job.Name, job: Scheduler.Job): F[Boolean]
}

object Scheduler {
  sealed abstract class CreateError extends NoStackTrace

  object CreateError {
    case object JobAlreadyExists extends CreateError
  }

  final case class Job(name: Job.Name, schedule: Job.Schedule, target: Job.Target)

  object Job {
    final case class Name(value: String) extends AnyVal

    final case class Schedule(value: String) extends AnyVal

    object Schedule {
      val Hourly: Schedule = Schedule("0 * * * *")
    }

    sealed abstract class Target extends Product with Serializable

    object Target {
      final case class Http(method: String, url: String) extends Target
    }
  }
}
