package io.taig.taigless.validation

import cats.syntax.all._

trait Fields[A] {
  def decode(value: String): Either[String, A]

  def encode(value: A): String
}

object Fields {
  def apply[A](implicit fields: Fields[A]): Fields[A] = fields

  trait Ops[A] {
    def typeClassInstance: Fields[A]
    def self: A
    def encode: String = typeClassInstance.encode(self)
  }

  trait ToFieldsOps {
    implicit def toFieldOps[A](target: A)(implicit fields: Fields[A]): Ops[A] = new Ops[A] {
      val self: A = target
      val typeClassInstance: Fields[A] = fields
    }
  }

  implicit def option[A](implicit fields: Fields[A]): Fields[Option[A]] = new Fields[Option[A]] {
    override def decode(value: String): Either[String, Option[A]] = value match {
      case "*"   => None.asRight
      case value => fields.decode(value).map(_.some)
    }

    override def encode(value: Option[A]): String = value.map(fields.encode).getOrElse("*")
  }
}
