package io.taig.taigless

import scala.annotation.nowarn

package object validation {
  private[validation] def name(value: Any): String = {
    val name = toCamelCase(value.getClass.getSimpleName)
    if (name.endsWith("$")) name.init else name
  }

  @nowarn
  private def toKebapCase(value: String): String =
    value.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase

  def toCamelCase(value: String): String =
    if (value.isEmpty) value
    else value.charAt(0).toLower +: value.tail
}
