/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.localrepo;

import io.takari.aether.localrepo.ArtifactValidator;
import io.takari.aether.localrepo.TrackingFileManager;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class TakariLocalRepositoryManager
implements LocalRepositoryManager {
    public static final String REPOSITORY_URI = ".repositoryUri";
    private static final String LOCAL_REPO_ID = "";
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;
    private final LocalRepository localRepository;
    private final List<ArtifactValidator> validators;

    public TakariLocalRepositoryManager(File basedir, RepositorySystemSession session, List<ArtifactValidator> validators) {
        if (basedir == null) {
            throw new IllegalArgumentException("base directory has not been specified");
        }
        this.validators = validators;
        this.localRepository = new LocalRepository(basedir.getAbsoluteFile(), "enhanced");
        String filename = TakariLocalRepositoryManager.getString(session, LOCAL_REPO_ID, "aether.enhancedLocalRepository.trackingFilename");
        if (filename.length() <= 0 || filename.contains("/") || filename.contains("\\") || filename.contains("..")) {
            filename = "_remote.repositories";
        }
        this.trackingFilename = filename;
        this.trackingFileManager = new TrackingFileManager();
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            Properties props = this.readRepos(file);
            if (props.get(this.getKey(file, LOCAL_REPO_ID)) != null) {
                result.setAvailable(true);
            } else {
                RemoteRepository remoteRepositoryForArtifact = null;
                String context = request.getContext();
                for (RemoteRepository remoteRepository : request.getRepositories()) {
                    if (props.get(this.getKey(file, this.getRepositoryKey(remoteRepository, context))) == null) continue;
                    remoteRepositoryForArtifact = remoteRepository;
                    result.setRepository(remoteRepositoryForArtifact);
                    break;
                }
                for (ArtifactValidator validator : this.validators) {
                    validator.validateOnFind(request.getArtifact(), this.localRepository, remoteRepositoryForArtifact);
                }
                result.setFile(file);
                result.setAvailable(true);
            }
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        boolean local;
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton(LOCAL_REPO_ID) : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        Artifact artifact = request.getArtifact();
        boolean bl = local = request.getRepository() == null;
        if (artifact == null) {
            throw new IllegalArgumentException("artifact to register not specified");
        }
        String path = this.getPathForArtifact(artifact, local);
        File file = new File(this.getRepository().getBasedir(), path);
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(file, repository), LOCAL_REPO_ID);
        }
        File trackingFile = this.getTrackingFile(file);
        this.trackingFileManager.update(trackingFile, updates);
        for (ArtifactValidator validator : this.validators) {
            validator.validateOnAdd(request.getArtifact(), this.localRepository, request.getRepository());
        }
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys = new HashSet<String>();
        if (contexts != null) {
            for (String context : contexts) {
                keys.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys;
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }

    private String getKey(File file, String repository) {
        return file.getName() + '>' + repository;
    }

    public static String getString(Map<?, ?> properties, String defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof String)) continue;
            return (String)value;
        }
        return defaultValue;
    }

    public static String getString(RepositorySystemSession session, String defaultValue, String ... keys) {
        return TakariLocalRepositoryManager.getString(session.getConfigProperties(), defaultValue, keys);
    }

    public LocalRepository getRepository() {
        return this.localRepository;
    }

    String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getBaseVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        if (local) {
            path.append(artifact.getBaseVersion());
        } else {
            path.append(artifact.getVersion());
        }
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }

    public String getPathForLocalArtifact(Artifact artifact) {
        return this.getPathForArtifact(artifact, true);
    }

    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getPathForArtifact(artifact, false);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.getPath(metadata, "local");
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getPath(metadata, this.getRepositoryKey(repository, context));
    }

    String getRepositoryKey(RemoteRepository repository, String context) {
        String key;
        if (repository.isRepositoryManager()) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(repository.getId());
            buffer.append('-');
            TreeSet<String> subKeys = new TreeSet<String>();
            for (RemoteRepository mirroredRepo : repository.getMirroredRepositories()) {
                subKeys.add(mirroredRepo.getId());
            }
            SimpleDigest digest = new SimpleDigest();
            digest.update(context);
            for (String subKey : subKeys) {
                digest.update(subKey);
            }
            buffer.append(digest.digest());
            key = buffer.toString();
        } else {
            key = repository.getId();
        }
        return key;
    }

    private String getPath(Metadata metadata, String repositoryKey) {
        StringBuilder path = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            path.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                path.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    path.append(metadata.getVersion()).append('/');
                }
            }
        }
        path.append(this.insertRepositoryKey(metadata.getType(), repositoryKey));
        return path.toString();
    }

    private String insertRepositoryKey(String filename, String repositoryKey) {
        int idx = filename.indexOf(46);
        String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
        return result;
    }

    public LocalArtifactResult Xfind(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForArtifact(request.getArtifact(), false);
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        return result;
    }

    public void Xadd(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    public String toString() {
        return String.valueOf(this.getRepository());
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = new LocalMetadataResult(request);
        Metadata metadata = request.getMetadata();
        String context = request.getContext();
        RemoteRepository remote = request.getRepository();
        String path = remote != null ? this.getPathForRemoteMetadata(metadata, remote, context) : this.getPathForLocalMetadata(metadata);
        File file = new File(this.getRepository().getBasedir(), path);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }

    class SimpleDigest {
        private MessageDigest digest;
        private long hash;

        public SimpleDigest() {
            try {
                this.digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this.digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException ne) {
                    this.digest = null;
                    this.hash = 13L;
                }
            }
        }

        public void update(String data) {
            if (data == null || data.length() <= 0) {
                return;
            }
            if (this.digest != null) {
                try {
                    this.digest.update(data.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                this.hash = this.hash * 31L + (long)data.hashCode();
            }
        }

        public String digest() {
            if (this.digest != null) {
                StringBuilder buffer = new StringBuilder(64);
                byte[] bytes = this.digest.digest();
                for (int i = 0; i < bytes.length; ++i) {
                    int b = bytes[i] & 0xFF;
                    if (b < 16) {
                        buffer.append('0');
                    }
                    buffer.append(Integer.toHexString(b));
                }
                return buffer.toString();
            }
            return Long.toHexString(this.hash);
        }
    }
}

