/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.csv;

import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.LoadAcceptor;
import io.tapack.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class CsvProvider
implements FileHandler,
LoadAcceptor {
    @Override
    public boolean accept(Class<? extends LoadAcceptor> loadclass) {
        return this.getClass().equals(loadclass);
    }

    @Override
    public void checkFileContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat((String)("THE FILE MUST CONTAIN MESSAGE '" + textContent + "' BUT IT ISN'T "), (Object)org.apache.commons.io.FileUtils.readFileToString((File)lastDownloadedFile), (Matcher)CoreMatchers.containsString((String)textContent));
    }

    @Override
    public void checkFileDoesNotContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat((String)("THE FILE '" + lastDownloadedFile.getName() + "' SHOULD NOT CONTAIN TEXT '" + textContent + "', BUT IT CONTAIN"), (Object)org.apache.commons.io.FileUtils.readFileToString((File)lastDownloadedFile), (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)textContent)));
    }

    @Override
    public void verifyThatFileTextContentIsEqualToFileTextContent(String filePath, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        List expectedCsv = org.apache.commons.io.FileUtils.readLines((File)FileUtils.getFileFromResourcesByFilePath((String)filePath));
        List actualCsv = org.apache.commons.io.FileUtils.readLines((File)lastDownloadedFile);
        Assert.assertEquals((String)("THE FILE '" + lastDownloadedFile.getName() + "' DOESN'T CONTAIN EXPECTED VALUE"), (Object)expectedCsv, (Object)actualCsv);
    }

    @Override
    public void verifyFilesOnEqual(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        throw new UnsupportedOperationException("verifyFilesOnEqual doesn't support for csv");
    }

    @Override
    public void verifyThatFileHasOccurrencesOfText(int count, String textContent, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        throw new UnsupportedOperationException("verifyThatFileHasOccurrencesOfText doesn't support for csv");
    }

    @Override
    public void verifyFileIsSimilarToFile(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        throw new UnsupportedOperationException("verifyFileIsSimilarToFile doesn't support for csv");
    }
}

