/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.pdf;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFWords {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFWords.class);
    private Map<Integer, String> pdfData;

    public void pdfShouldEqualTo(PDFWords expectedPDFcontent) {
        MatcherAssert.assertThat(this.pdfData, (Matcher)CoreMatchers.equalTo(expectedPDFcontent.pdfData));
    }

    public void parsePdf(String filename) throws IOException {
        PdfReader reader = new PdfReader(filename);
        LOGGER.trace("Reading file " + filename);
        this.pdfData = new HashMap<Integer, String>();
        int numberOfPages = reader.getNumberOfPages();
        for (int page = 1; page <= numberOfPages; ++page) {
            LOGGER.trace("Reading page " + page);
            String textFromPage = PdfTextExtractor.getTextFromPage((PdfReader)reader, (int)page);
            this.pdfData.put(page, textFromPage);
        }
    }

    public void pdfShouldContainUnOrdered(PDFWords expectedPDFcontent) {
        Collection<String> values = this.pdfData.values();
        for (String value : values) {
            expectedPDFcontent.pdfShouldContain(value);
        }
    }

    public void pdfShouldContain(String expectedValue) {
        Collection<String> values = this.pdfData.values();
        this.collectionShouldContain(expectedValue, values);
    }

    public void pdfShouldNotContain(String expectedValue) {
        Collection<String> values = this.pdfData.values();
        this.collectionShouldNotContain(expectedValue, values);
    }

    public void pdfShouldContainOccurrencesOfString(String expectedValue, int expectedCount) {
        Collection<String> values = this.pdfData.values();
        Assert.assertEquals((String)("THE MESSAGE '" + expectedValue + "' EXPECTED " + expectedCount + " BUT IN REALY = " + this.getCountMatchesInCollectiont(expectedValue, values)), (long)expectedCount, (long)this.getCountMatchesInCollectiont(expectedValue, values));
    }

    public void pdfShouldContain(String expectedValue, String ignoreLinebreaks) {
        if (StringUtils.isEmpty((String)ignoreLinebreaks)) {
            this.pdfShouldContain(expectedValue);
        }
        Collection<String> values = this.pdfData.values();
        values = this.removeLinebreaks(values);
        this.collectionShouldContain(expectedValue, values);
    }

    public void pdfShouldContain(String expectedValue, String ignoreLinebreaks, String ignoreCase) {
        if (StringUtils.isEmpty((String)ignoreCase)) {
            this.pdfShouldContain(expectedValue, ignoreLinebreaks);
        }
        Collection<String> values = this.pdfData.values();
        values = this.removeLinebreaks(values);
        this.collectionShouldContain(expectedValue, values, StringUtils.isNotEmpty((String)ignoreCase));
    }

    protected Collection<String> removeLinebreaks(Collection<String> values) {
        ArrayList<String> contentWithoutLinebreacks = new ArrayList<String>();
        for (String string : values) {
            String reformattedString = string.replaceAll("\\n", " ");
            while (reformattedString.contains("  ")) {
                reformattedString = reformattedString.replaceAll("  ", " ");
            }
            contentWithoutLinebreacks.add(reformattedString);
        }
        return contentWithoutLinebreacks;
    }

    private boolean isContaining(String expectedValue, boolean ignoreCase, String content) {
        return ignoreCase ? StringUtils.containsIgnoreCase((String)content, (String)expectedValue) : StringUtils.contains((String)content, (String)expectedValue);
    }

    private void collectionShouldContain(String expectedValue, Collection<String> values) {
        this.collectionShouldContain(expectedValue, values, false);
    }

    private void collectionShouldContain(String expectedValue, Collection<String> values, boolean ignoreCase) {
        for (String content : values) {
            if (!this.isContaining(expectedValue, ignoreCase, content)) continue;
            return;
        }
        throw new AssertionError((Object)("COULD NOT FIND " + expectedValue + " IN " + this.pdfData));
    }

    private void collectionShouldNotContain(String expectedValue, Collection<String> values, boolean ignoreCase) {
        for (String content : values) {
            if (this.isContaining(expectedValue, ignoreCase, content)) {
                throw new AssertionError((Object)("TEXT '" + expectedValue + "' CONTAINS IN " + this.pdfData));
            }
        }
    }

    private int getCountMatchesInCollectiont(String expectedValue, Collection<String> values) {
        int count = 0;
        for (String content : values) {
            count += StringUtils.countMatches((String)content, (String)expectedValue);
        }
        return count;
    }

    private void collectionShouldNotContain(String expectedValue, Collection<String> values) {
        this.collectionShouldNotContain(expectedValue, values, false);
    }
}

