/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.steps.bdd;

import io.tapack.satisfy.csv.CsvProvider;
import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.FileStepFactory;
import io.tapack.satisfy.util.DownloadHelper;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.jbehave.core.annotations.Then;
import org.xml.sax.SAXException;

public class CsvSteps {
    public FileHandler steps = FileStepFactory.getCsvSteps(CsvProvider.class);

    @Then(value="verify that csv file contains text '$textContent' with '$key'")
    public void thenVerifyThatCsvFileContainsText(String textContent, String key) throws IOException {
        this.steps.checkFileContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify that csv file does not contains text '$textContent' with '$key'")
    public void thenVerifyCsvFileDoesNotContainText(String textContent, String key) throws IOException {
        this.steps.checkFileDoesNotContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify that csv text content is equal to '$filePath' text content in file with key '$key'")
    public void thenVerifyThatCsvTextContentIsEqualToFileTextContent(String filePath, String key) throws IOException, ParserConfigurationException, SAXException {
        this.steps.verifyThatFileTextContentIsEqualToFileTextContent(filePath, DownloadHelper.getDownloadedFile(key));
    }
}

