/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.steps.bdd;

import io.tapack.satisfy.pdf.PdfProvider;
import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.FileStepFactory;
import io.tapack.satisfy.util.DownloadHelper;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.jbehave.core.annotations.Then;
import org.xml.sax.SAXException;

public class PdfSteps {
    public FileHandler steps = FileStepFactory.getPdfSteps(PdfProvider.class);

    @Then(value="verify that pdf file contains text '$textContent' with '$key'")
    public void thenVerifyThatPdfFileContainsText(String textContent, String key) throws IOException {
        this.steps.checkFileContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify that pdf file does not contains text '$textContent' with '$key'")
    public void thenVerifyPdfFileDoesNotContainText(String textContent, String key) throws IOException {
        this.steps.checkFileDoesNotContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify that pdf file has '$count' occurrences of text '$textContent' with '$key'")
    public void thenVerifyThatPdfFileHasOccurrencesOfText(int count, String textContent, String key) throws IOException, ParserConfigurationException, SAXException {
        this.steps.verifyThatFileHasOccurrencesOfText(count, textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify that pdf text content is equal to '$filePath' text content in file with key '$key'")
    public void thenVerifyThatPdfTextContentIsEqualToFileTextContent(String filePath, String key) throws IOException, ParserConfigurationException, SAXException {
        this.steps.verifyThatFileTextContentIsEqualToFileTextContent(filePath, DownloadHelper.getDownloadedFile(key));
    }
}

