/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.steps.bdd;

import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.FileStepFactory;
import io.tapack.satisfy.util.DownloadHelper;
import io.tapack.satisfy.xml.XmlProvider;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.jbehave.core.annotations.Then;
import org.xml.sax.SAXException;

public class XmlSteps {
    public FileHandler steps = FileStepFactory.getXmlSteps(XmlProvider.class);

    @Then(value="verify XML file content is equal to file '$filePath' with '$key'")
    public void verifyXMLIsEqualToFile(String filePath, String key) throws IOException, SAXException, ParserConfigurationException {
        this.steps.verifyFilesOnEqual(filePath, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify XML file content is similar to file '$filePath' with '$key'")
    public void verifyXMLIsSimilarToFile(String filePath, String key) throws IOException, SAXException, ParserConfigurationException {
        this.steps.verifyFileIsSimilarToFile(filePath, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify XML file contains text '$textContent' with '$key'")
    public void verifyXMLContainText(String textContent, String key) throws IOException {
        this.steps.checkFileContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }

    @Then(value="verify XML file does not contain text '$textContent' with '$key'")
    public void verifyXMLDoesNotContainText(String textContent, String key) throws IOException {
        this.steps.checkFileDoesNotContainText(textContent, DownloadHelper.getDownloadedFile(key));
    }
}

