/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy.xml;

import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.LoadAcceptor;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.IgnoreTextAndAttributeValuesDifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProvider
implements FileHandler,
LoadAcceptor {
    @Override
    public boolean accept(Class<? extends LoadAcceptor> loadclass) {
        return this.getClass().equals(loadclass);
    }

    @Override
    public void checkFileContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat((String)("THE FILE MUST CONTAIN MESSAGE '" + textContent + "' BUT IT ISN'T "), (Object)FileUtils.readFileToString((File)lastDownloadedFile), (Matcher)CoreMatchers.containsString((String)textContent));
    }

    @Override
    public void checkFileDoesNotContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat((String)("THE FILE '" + lastDownloadedFile.getName() + "' SHOULD NOT CONTAIN TEXT '" + textContent + "', BUT IT CONTAIN"), (Object)FileUtils.readFileToString((File)lastDownloadedFile), (Matcher)IsNot.not((Matcher)CoreMatchers.containsString((String)textContent)));
    }

    @Override
    public void verifyFilesOnEqual(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        FileReader controlXML = new FileReader(io.tapack.util.FileUtils.getFileFromResourcesByFilePath((String)filePath));
        FileReader testXML = new FileReader(lastDownloadedFile);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLAssert.assertXMLEqual((String)("THE FILE '" + lastDownloadedFile.getName() + "' DOESN'T CONTAIN EXPECTED VALUE"), (Reader)controlXML, (Reader)testXML);
    }

    @Override
    public void verifyFileIsSimilarToFile(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        FileReader controlXML = new FileReader(io.tapack.util.FileUtils.getFileFromResourcesByFilePath((String)filePath));
        FileReader testXML = new FileReader(lastDownloadedFile);
        Diff diff = new Diff((Reader)controlXML, (Reader)testXML);
        diff.overrideDifferenceListener((DifferenceListener)new IgnoreTextAndAttributeValuesDifferenceListener());
        XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
    }

    @Override
    public void verifyThatFileHasOccurrencesOfText(int count, String textContent, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(lastDownloadedFile);
        NodeList nodes = doc.getElementsByTagName(textContent);
        int actual = nodes.getLength();
        XMLAssert.assertEquals((int)count, (int)actual);
    }

    @Override
    public void verifyThatFileTextContentIsEqualToFileTextContent(String filePath, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        this.verifyFileIsSimilarToFile(filePath, lastDownloadedFile);
    }
}

