/*
 * Copyright © 2015 Tapack, and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Research Projects is dual-licensed under the GNU General Public
 * License, version 2.0 (GPLv2) and the Tapack Commercial License.
 *
 * Solely for non-commercial purposes. A purpose is non-commercial only if
 * it is in no manner primarily intended for or directed toward commercial
 * advantage or private monetary compensation.
 *
 * This Tapack Software is supplied to you by Tapack in consideration of your
 * agreement to the following terms, and your use, installation, modification
 * or redistribution of this Tapack Software constitutes acceptance of these
 * terms. If you do not agree with these terms, please do not use, install,
 * modify or redistribute this Tapack Software.
 *
 * Neither the name, trademarks, service marks or logos of Tapack may be used
 * to endorse or promote products derived from the Tapack Software without
 * specific prior written permission from Tapack.
 *
 * The Tapack Software is provided by Tapack on an "AS IS" basis. TAPACK MAKES NO
 * WARRANTIES, EXPRESS  OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, REGARDING THE TAPACK SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 * COMBINATION WITH YOUR PRODUCTS.
 *
 * IN NO EVENT SHALL TAPACK BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION
 * AND/OR DISTRIBUTION OF THE TAPACK SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER
 * THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR
 * OTHERWISE, EVEN IF TAPACK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * A copy of the GNU General Public License is included in the distribution in
 * the file LICENSE and at
 *
 *     http://www.gnu.org/licenses/gpl-2.0.html
 *
 * If you are using the Research Projects for commercial purposes, we
 * encourage you to visit
 *
 *     http://products.tapack.io/license
 *
 * for more details.
 *
 * This software or hardware and documentation may provide access to
 * or information on content, products, and services from third parties.
 * Tapack and its affiliates are not responsible for and expressly disclaim
 * all warranties of any kind with respect to third-party content, products,
 * and services. Tapack and its affiliates will not be responsible for any loss,
 * costs, or damages incurred due to your access to or use of third-party
 * content, products, or services. If a third-party content exists, the
 * additional copyright notices and license terms applicable to portions of the
 * software are set forth in the THIRD_PARTY_LICENSE_README file.
 *
 * Please contact Tapack or visit www.tapack.io if you need additional
 * information or have any questions.
 */

package io.tapack.satisfy.steps.bdd;

import io.tapack.satisfy.csv.CsvProvider;
import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.FileStepFactory;
import org.jbehave.core.annotations.Then;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;

import static io.tapack.satisfy.util.DownloadHelper.getDownloadedFile;

public class CsvSteps {
    public FileHandler steps = FileStepFactory.getCsvSteps(CsvProvider.class);

    @Then("verify that csv file contains text '$textContent' with '$key'")
    public void thenVerifyThatCsvFileContainsText(String textContent, String key) throws IOException {
        steps.checkFileContainText(textContent, getDownloadedFile(key));
    }

    @Then("verify that csv file does not contains text '$textContent' with '$key'")
    public void thenVerifyCsvFileDoesNotContainText(String textContent, String key) throws IOException {
        steps.checkFileDoesNotContainText(textContent, getDownloadedFile(key));
    }

    @Then("verify that csv text content is equal to '$filePath' text content in file with key '$key'")
    public void thenVerifyThatCsvTextContentIsEqualToFileTextContent(String filePath, String key) throws IOException, ParserConfigurationException, SAXException {
        steps.verifyThatFileTextContentIsEqualToFileTextContent(filePath, getDownloadedFile(key));
    }
}
