/*
 * Copyright © 2015 Tapack, and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Research Projects is dual-licensed under the GNU General Public
 * License, version 2.0 (GPLv2) and the Tapack Commercial License.
 *
 * Solely for non-commercial purposes. A purpose is non-commercial only if
 * it is in no manner primarily intended for or directed toward commercial
 * advantage or private monetary compensation.
 *
 * This Tapack Software is supplied to you by Tapack in consideration of your
 * agreement to the following terms, and your use, installation, modification
 * or redistribution of this Tapack Software constitutes acceptance of these
 * terms. If you do not agree with these terms, please do not use, install,
 * modify or redistribute this Tapack Software.
 *
 * Neither the name, trademarks, service marks or logos of Tapack may be used
 * to endorse or promote products derived from the Tapack Software without
 * specific prior written permission from Tapack.
 *
 * The Tapack Software is provided by Tapack on an "AS IS" basis. TAPACK MAKES NO
 * WARRANTIES, EXPRESS  OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, REGARDING THE TAPACK SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 * COMBINATION WITH YOUR PRODUCTS.
 *
 * IN NO EVENT SHALL TAPACK BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION
 * AND/OR DISTRIBUTION OF THE TAPACK SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER
 * THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR
 * OTHERWISE, EVEN IF TAPACK HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * A copy of the GNU General Public License is included in the distribution in
 * the file LICENSE and at
 *
 *     http://www.gnu.org/licenses/gpl-2.0.html
 *
 * If you are using the Research Projects for commercial purposes, we
 * encourage you to visit
 *
 *     http://products.tapack.io/license
 *
 * for more details.
 *
 * This software or hardware and documentation may provide access to
 * or information on content, products, and services from third parties.
 * Tapack and its affiliates are not responsible for and expressly disclaim
 * all warranties of any kind with respect to third-party content, products,
 * and services. Tapack and its affiliates will not be responsible for any loss,
 * costs, or damages incurred due to your access to or use of third-party
 * content, products, or services. If a third-party content exists, the
 * additional copyright notices and license terms applicable to portions of the
 * software are set forth in the THIRD_PARTY_LICENSE_README file.
 *
 * Please contact Tapack or visit www.tapack.io if you need additional
 * information or have any questions.
 */

package io.tapack.satisfy.xml;

import io.tapack.satisfy.spi.FileHandler;
import io.tapack.satisfy.spi.LoadAcceptor;
import org.apache.commons.io.FileUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.IgnoreTextAndAttributeValuesDifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import static io.tapack.util.FileUtils.getFileFromResourcesByFilePath;
import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.core.IsNot.not;



public class XmlProvider implements FileHandler, LoadAcceptor {

    @Override
    public boolean accept(Class<? extends LoadAcceptor> loadclass) {
        return this.getClass().equals(loadclass);
    }

    @Override
    public void checkFileContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat("THE FILE MUST CONTAIN MESSAGE '" + textContent + "' BUT IT ISN'T ", FileUtils.readFileToString(lastDownloadedFile), containsString(textContent));
    }

    @Override
    public void checkFileDoesNotContainText(String textContent, File lastDownloadedFile) throws IOException {
        Assert.assertThat("THE FILE '" + lastDownloadedFile.getName() + "' SHOULD NOT CONTAIN TEXT '" + textContent + "', BUT IT CONTAIN", FileUtils.readFileToString(lastDownloadedFile), not(containsString(textContent)));
    }

    @Override
    public void verifyFilesOnEqual(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        FileReader controlXML = new FileReader(getFileFromResourcesByFilePath(filePath));
        FileReader testXML = new FileReader(lastDownloadedFile);
        XMLUnit.setIgnoreWhitespace(true);
        XMLAssert.assertXMLEqual("THE FILE '" + lastDownloadedFile.getName() + "' DOESN'T CONTAIN EXPECTED VALUE", controlXML, testXML);
    }

    @Override
    public void verifyFileIsSimilarToFile(String filePath, File lastDownloadedFile) throws IOException, SAXException, ParserConfigurationException {
        FileReader controlXML = new FileReader(getFileFromResourcesByFilePath(filePath));
        FileReader testXML = new FileReader(lastDownloadedFile);
        Diff diff = new Diff(controlXML, testXML);
        diff.overrideDifferenceListener(new IgnoreTextAndAttributeValuesDifferenceListener());
        XMLAssert.assertXMLEqual(diff, true);
    }

    @Override
    public void verifyThatFileHasOccurrencesOfText(int count, String textContent, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(lastDownloadedFile);
        NodeList nodes = doc.getElementsByTagName(textContent);
        int actual = nodes.getLength();
        XMLAssert.assertEquals(count, actual);
    }

    //EMPTY STUB
    @Override
    public void verifyThatFileTextContentIsEqualToFileTextContent(String filePath, File lastDownloadedFile) throws IOException, ParserConfigurationException, SAXException {
        verifyFileIsSimilarToFile(filePath, lastDownloadedFile);
    }


}
