/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spark.connector.config;

import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.spark.connector.config.Credentials;
import io.tarantool.spark.connector.config.ErrorTypes$;
import io.tarantool.spark.connector.config.Retries;
import io.tarantool.spark.connector.config.TarantoolConfig;
import io.tarantool.spark.connector.config.TarantoolDefaults$;
import io.tarantool.spark.connector.config.Timeouts;
import org.apache.spark.SparkConf;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class TarantoolConfig$
implements Serializable {
    public static final TarantoolConfig$ MODULE$;
    private final String SPARK_PREFIX;
    private final String PREFIX;
    private final String USERNAME;
    private final String PASSWORD;
    private final String CONNECT_TIMEOUT;
    private final String READ_TIMEOUT;
    private final String REQUEST_TIMEOUT;
    private final String HOSTS;
    private final String CONNECTIONS;
    private final String RETRIES;
    private final String RETRIES_ERROR_TYPE;
    private final String RETRIES_ATTEMPTS;
    private final String RETRIES_DELAY;
    private final String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_USERNAME;
    private final String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_PASSWORD;
    private final String SPARK_CONNECT_TIMEOUT;
    private final String SPARK_READ_TIMEOUT;
    private final String SPARK_REQUEST_TIMEOUT;
    private final String SPARK_HOSTS;
    private final String SPARK_CONNECTIONS;
    private final String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_RETRIES_ERROR_TYPE;
    private final String SPARK_RETRIES_ATTEMPTS;
    private final String SPARK_RETRIES_DELAY;

    static {
        new TarantoolConfig$();
    }

    private String SPARK_PREFIX() {
        return this.SPARK_PREFIX;
    }

    private String PREFIX() {
        return this.PREFIX;
    }

    private String USERNAME() {
        return this.USERNAME;
    }

    private String PASSWORD() {
        return this.PASSWORD;
    }

    private String CONNECT_TIMEOUT() {
        return this.CONNECT_TIMEOUT;
    }

    private String READ_TIMEOUT() {
        return this.READ_TIMEOUT;
    }

    private String REQUEST_TIMEOUT() {
        return this.REQUEST_TIMEOUT;
    }

    private String HOSTS() {
        return this.HOSTS;
    }

    private String CONNECTIONS() {
        return this.CONNECTIONS;
    }

    private String RETRIES() {
        return this.RETRIES;
    }

    private String RETRIES_ERROR_TYPE() {
        return this.RETRIES_ERROR_TYPE;
    }

    private String RETRIES_ATTEMPTS() {
        return this.RETRIES_ATTEMPTS;
    }

    private String RETRIES_DELAY() {
        return this.RETRIES_DELAY;
    }

    public String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_USERNAME() {
        return this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_USERNAME;
    }

    public String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_PASSWORD() {
        return this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_PASSWORD;
    }

    private String SPARK_CONNECT_TIMEOUT() {
        return this.SPARK_CONNECT_TIMEOUT;
    }

    private String SPARK_READ_TIMEOUT() {
        return this.SPARK_READ_TIMEOUT;
    }

    private String SPARK_REQUEST_TIMEOUT() {
        return this.SPARK_REQUEST_TIMEOUT;
    }

    private String SPARK_HOSTS() {
        return this.SPARK_HOSTS;
    }

    private String SPARK_CONNECTIONS() {
        return this.SPARK_CONNECTIONS;
    }

    public String io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_RETRIES_ERROR_TYPE() {
        return this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_RETRIES_ERROR_TYPE;
    }

    private String SPARK_RETRIES_ATTEMPTS() {
        return this.SPARK_RETRIES_ATTEMPTS;
    }

    private String SPARK_RETRIES_DELAY() {
        return this.SPARK_RETRIES_DELAY;
    }

    public TarantoolConfig apply(SparkConf cfg) {
        return new TarantoolConfig(this.parseHosts(cfg), this.parseCredentials(cfg), this.parseTimeouts(cfg), this.parseIntOption(cfg, this.CONNECTIONS(), this.SPARK_CONNECTIONS()), this.parseRetries(cfg));
    }

    public Option<Credentials> parseCredentials(SparkConf cfg) {
        Option username = cfg.getOption(this.USERNAME()).orElse((Function0)new Serializable(cfg){
            public static final long serialVersionUID = 0L;
            private final SparkConf cfg$1;

            public final Option<String> apply() {
                return this.cfg$1.getOption(TarantoolConfig$.MODULE$.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_USERNAME());
            }
            {
                this.cfg$1 = cfg$1;
            }
        });
        Option password = cfg.getOption(this.PASSWORD()).orElse((Function0)new Serializable(cfg){
            public static final long serialVersionUID = 0L;
            private final SparkConf cfg$1;

            public final Option<String> apply() {
                return this.cfg$1.getOption(TarantoolConfig$.MODULE$.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_PASSWORD());
            }
            {
                this.cfg$1 = cfg$1;
            }
        });
        return username.isDefined() ? new Some((Object)new Credentials((String)username.get(), (String)password.get())) : None$.MODULE$;
    }

    public Seq<TarantoolServerAddress> parseHosts(SparkConf cfg) {
        TarantoolServerAddress[] hosts = (TarantoolServerAddress[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cfg.get(this.HOSTS(), "").split(",")).union((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])cfg.get(this.SPARK_HOSTS(), "").split(",")), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TarantoolServerAddress apply(String a) {
                return new TarantoolServerAddress(a);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TarantoolServerAddress.class)));
        if (Predef$.MODULE$.refArrayOps((Object[])hosts).isEmpty()) {
            hosts = (TarantoolServerAddress[])((Object[])new TarantoolServerAddress[]{new TarantoolServerAddress(TarantoolDefaults$.MODULE$.DEFAULT_HOST())});
        }
        return Predef$.MODULE$.wrapRefArray((Object[])hosts);
    }

    public Timeouts parseTimeouts(SparkConf cfg) {
        return new Timeouts(this.parseIntOption(cfg, this.CONNECT_TIMEOUT(), this.SPARK_CONNECT_TIMEOUT()), this.parseIntOption(cfg, this.READ_TIMEOUT(), this.SPARK_READ_TIMEOUT()), this.parseIntOption(cfg, this.REQUEST_TIMEOUT(), this.SPARK_REQUEST_TIMEOUT()));
    }

    public Option<Retries> parseRetries(SparkConf cfg) {
        None$ none$;
        Option strErrorType = cfg.getOption(this.RETRIES_ERROR_TYPE()).orElse((Function0)new Serializable(cfg){
            public static final long serialVersionUID = 0L;
            private final SparkConf cfg$3;

            public final Option<String> apply() {
                return this.cfg$3.getOption(TarantoolConfig$.MODULE$.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_RETRIES_ERROR_TYPE());
            }
            {
                this.cfg$3 = cfg$3;
            }
        });
        Option<Object> retryAttempts = this.parseIntOption(cfg, this.RETRIES_ATTEMPTS(), this.SPARK_RETRIES_ATTEMPTS());
        Option<Object> retryDelay = this.parseIntOption(cfg, this.RETRIES_DELAY(), this.SPARK_RETRIES_DELAY());
        if (strErrorType.isDefined()) {
            Enumeration.Value errorType;
            Enumeration.Value value = errorType = ErrorTypes$.MODULE$.withName(((String)strErrorType.get()).toUpperCase());
            Enumeration.Value value2 = ErrorTypes$.MODULE$.NETWORK();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                if (retryAttempts.isEmpty()) {
                    throw new IllegalArgumentException("Number of retry attempts must be specified");
                }
                if (retryDelay.isEmpty()) {
                    throw new IllegalArgumentException("Delay between retry attempts must be specified");
                }
            }
            none$ = new Some((Object)new Retries(errorType, retryAttempts, retryDelay));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Object> parseIntOption(SparkConf cfg, String name, String nameWithSparkPrefix) {
        return cfg.getOption(name).orElse((Function0)new Serializable(cfg, nameWithSparkPrefix){
            public static final long serialVersionUID = 0L;
            private final SparkConf cfg$2;
            private final String nameWithSparkPrefix$1;

            public final Option<String> apply() {
                return this.cfg$2.getOption(this.nameWithSparkPrefix$1);
            }
            {
                this.cfg$2 = cfg$2;
                this.nameWithSparkPrefix$1 = nameWithSparkPrefix$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        });
    }

    public TarantoolConfig apply(Seq<TarantoolServerAddress> hosts, Option<Credentials> credentials, Timeouts timeouts, Option<Object> connections, Option<Retries> retries) {
        return new TarantoolConfig(hosts, credentials, timeouts, connections, retries);
    }

    public Option<Tuple5<Seq<TarantoolServerAddress>, Option<Credentials>, Timeouts, Option<Object>, Option<Retries>>> unapply(TarantoolConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5(x$0.hosts(), x$0.credentials(), (Object)x$0.timeouts(), x$0.connections(), x$0.retries()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TarantoolConfig$() {
        MODULE$ = this;
        this.SPARK_PREFIX = "spark.";
        this.PREFIX = "tarantool.";
        this.USERNAME = new StringBuilder().append((Object)this.PREFIX()).append((Object)"username").toString();
        this.PASSWORD = new StringBuilder().append((Object)this.PREFIX()).append((Object)"password").toString();
        this.CONNECT_TIMEOUT = new StringBuilder().append((Object)this.PREFIX()).append((Object)"connectTimeout").toString();
        this.READ_TIMEOUT = new StringBuilder().append((Object)this.PREFIX()).append((Object)"readTimeout").toString();
        this.REQUEST_TIMEOUT = new StringBuilder().append((Object)this.PREFIX()).append((Object)"requestTimeout").toString();
        this.HOSTS = new StringBuilder().append((Object)this.PREFIX()).append((Object)"hosts").toString();
        this.CONNECTIONS = new StringBuilder().append((Object)this.PREFIX()).append((Object)"connections").toString();
        this.RETRIES = new StringBuilder().append((Object)this.PREFIX()).append((Object)"retries.").toString();
        this.RETRIES_ERROR_TYPE = new StringBuilder().append((Object)this.RETRIES()).append((Object)"errorType").toString();
        this.RETRIES_ATTEMPTS = new StringBuilder().append((Object)this.RETRIES()).append((Object)"maxAttempts").toString();
        this.RETRIES_DELAY = new StringBuilder().append((Object)this.RETRIES()).append((Object)"delay").toString();
        this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_USERNAME = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.USERNAME()).toString();
        this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_PASSWORD = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.PASSWORD()).toString();
        this.SPARK_CONNECT_TIMEOUT = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.CONNECT_TIMEOUT()).toString();
        this.SPARK_READ_TIMEOUT = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.READ_TIMEOUT()).toString();
        this.SPARK_REQUEST_TIMEOUT = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.REQUEST_TIMEOUT()).toString();
        this.SPARK_HOSTS = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.HOSTS()).toString();
        this.SPARK_CONNECTIONS = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.CONNECTIONS()).toString();
        this.io$tarantool$spark$connector$config$TarantoolConfig$$SPARK_RETRIES_ERROR_TYPE = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.RETRIES_ERROR_TYPE()).toString();
        this.SPARK_RETRIES_ATTEMPTS = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.RETRIES_ATTEMPTS()).toString();
        this.SPARK_RETRIES_DELAY = new StringBuilder().append((Object)this.SPARK_PREFIX()).append((Object)this.RETRIES_DELAY()).toString();
    }
}

