/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.asserts;

import io.tech1.framework.domain.reflections.ReflectionProperty;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;

public final class Asserts {
    public static void assertNonNullOrThrow(Object object, String message) {
        if (Objects.isNull(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNonNullPropertyOrThrow(ReflectionProperty reflectionProperty) {
        if (Objects.isNull(reflectionProperty)) {
            throw new IllegalArgumentException("Unknown reflection property");
        }
        Asserts.assertNonNullOrThrow(reflectionProperty.getPropertyValue(), ExceptionsMessagesUtility.invalidAttribute(reflectionProperty.getPropertyName()));
    }

    public static void assertNonBlankOrThrow(String object, String message) {
        if (object.isBlank()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNonEmptyOrThrow(Collection<?> collection, String message) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrueOrThrow(boolean flag, String message) {
        if (!flag) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertFalseOrThrow(boolean flag, String message) {
        if (flag) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T requireNonNullOrThrow(T object, String message) {
        if (Objects.isNull(object)) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static void assertNonNullNotBlankOrThrow(Object object, String message) {
        Asserts.assertNonNullOrThrow(object, message);
        Asserts.assertNonBlankOrThrow(object.toString(), message);
    }

    public static void assertNonNullNotEmptyOrThrow(Collection<?> collection, String message) {
        Asserts.assertNonNullOrThrow(collection, message);
        Asserts.assertNonEmptyOrThrow(collection, message);
    }

    public static void assertZoneIdOrThrow(String zoneId, String message) {
        Asserts.assertNonNullNotBlankOrThrow(zoneId, message);
        if (!ZoneId.getAvailableZoneIds().contains(zoneId)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertDateTimePatternOrThrow(String dateTimePattern, String message) {
        Asserts.assertNonNullNotBlankOrThrow(dateTimePattern, message);
        Asserts.assertNonNullOrThrow(DateTimeFormatter.ofPattern(dateTimePattern), message);
    }

    @Generated
    private Asserts() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

