/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.concurrent;

import io.tech1.framework.domain.time.SchedulerConfiguration;
import io.tech1.framework.domain.time.TimeAmount;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;

public abstract class AbstractTimerTask {
    public static final TimeAmount DURATION_FOREVER = TimeAmount.of(1L, ChronoUnit.FOREVER);
    private volatile boolean isRunning = false;
    private final SchedulerConfiguration interval;
    private final TimeAmount duration;
    private long elapsedTime;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private Future<?> scheduledFuture = null;

    protected AbstractTimerTask(SchedulerConfiguration interval) {
        this.interval = interval;
        this.duration = DURATION_FOREVER;
        this.elapsedTime = 0L;
    }

    protected AbstractTimerTask(SchedulerConfiguration interval, TimeAmount duration) {
        this.interval = interval;
        this.duration = duration;
        this.elapsedTime = 0L;
    }

    public abstract void onTick();

    protected void onComplete() {
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            this.onTick();
            this.elapsedTime += this.interval.getDelayedSeconds();
            if (this.duration.toSeconds() > 0L && this.elapsedTime >= this.duration.toSeconds()) {
                this.onComplete();
                this.scheduledFuture.cancel(false);
            }
        }, this.interval.getInitialDelay(), this.interval.getDelay(), this.interval.getUnit());
    }

    public void stop() {
        this.pause();
        this.elapsedTime = 0L;
    }

    public void pause() {
        if (!this.isRunning) {
            return;
        }
        this.scheduledFuture.cancel(false);
        this.isRunning = false;
    }

    public void resume() {
        this.start();
    }

    public long getRemainingTime() {
        if (ChronoUnit.FOREVER.equals(this.duration.getUnit())) {
            return DURATION_FOREVER.toSeconds();
        }
        return this.duration.toSeconds() - this.elapsedTime;
    }

    @Generated
    public boolean isRunning() {
        return this.isRunning;
    }

    @Generated
    public long getElapsedTime() {
        return this.elapsedTime;
    }
}

