/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.exceptions;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.exceptions.ExceptionEntityType;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class ExceptionEntity {
    private static final String ATTRIBUTE_SHORT_MESSAGE = "shortMessage";
    private static final String ATTRIBUTE_FULL_MESSAGE = "fullMessage";
    private final ExceptionEntityType exceptionEntityType;
    private final Map<String, Object> attributes;
    private final long timestamp;

    public ExceptionEntity(ExceptionEntityType exceptionEntityType, Map<String, Object> attributes) {
        Asserts.assertNonNullOrThrow((Object)exceptionEntityType, ExceptionsMessagesUtility.invalidAttribute("ResponseExceptionEntity.exceptionEntityType"));
        this.exceptionEntityType = exceptionEntityType;
        this.attributes = new HashMap<String, Object>(attributes);
        this.timestamp = System.currentTimeMillis();
    }

    public void addAttribute(String attributeKey, Object value) {
        this.attributes.put(attributeKey, value);
    }

    public static ExceptionEntity of(ExceptionEntityType exceptionEntityType, String shortMessage, String fullMessage) {
        return new ExceptionEntity(exceptionEntityType, Map.of(ATTRIBUTE_SHORT_MESSAGE, shortMessage, ATTRIBUTE_FULL_MESSAGE, fullMessage));
    }

    public static ExceptionEntity of(Exception exception) {
        String exceptionMessage = exception.getMessage();
        return ExceptionEntity.of(ExceptionEntityType.ERROR, exceptionMessage, exceptionMessage);
    }

    @Generated
    public ExceptionEntityType getExceptionEntityType() {
        return this.exceptionEntityType;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionEntity)) {
            return false;
        }
        ExceptionEntity other = (ExceptionEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        ExceptionEntityType this$exceptionEntityType = this.getExceptionEntityType();
        ExceptionEntityType other$exceptionEntityType = other.getExceptionEntityType();
        if (this$exceptionEntityType == null ? other$exceptionEntityType != null : !((Object)((Object)this$exceptionEntityType)).equals((Object)other$exceptionEntityType)) {
            return false;
        }
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExceptionEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        ExceptionEntityType $exceptionEntityType = this.getExceptionEntityType();
        result = result * 59 + ($exceptionEntityType == null ? 43 : ((Object)((Object)$exceptionEntityType)).hashCode());
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExceptionEntity(exceptionEntityType=" + this.getExceptionEntityType() + ", attributes=" + this.getAttributes() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

