/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.geo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.tech1.framework.domain.http.requests.IPAddress;
import io.tech1.framework.domain.utilities.strings.StringUtility;
import java.util.Objects;
import lombok.Generated;

public class GeoLocation {
    private final String ipAddr;
    private final String country;
    @JsonIgnore
    private final String city;
    @JsonIgnore
    private final String exceptionDetails;

    private GeoLocation(String ipAddr, String country, String city, String exceptionDetails) {
        this.ipAddr = ipAddr;
        if (Objects.nonNull(country)) {
            this.country = country.trim();
            this.city = Objects.nonNull(city) ? city.trim() : null;
        } else {
            this.country = "Unknown";
            this.city = null;
        }
        this.exceptionDetails = exceptionDetails;
    }

    public static GeoLocation unknown(IPAddress ipAddress, String exceptionDetails) {
        return new GeoLocation(GeoLocation.getIpAddrOrUnknown(ipAddress), "Unknown", "Unknown", exceptionDetails);
    }

    public static GeoLocation processing(IPAddress ipAddress) {
        return new GeoLocation(GeoLocation.getIpAddrOrUnknown(ipAddress), "[?]", "[?]", "");
    }

    public static GeoLocation processed(IPAddress ipAddress, String country, String city) {
        return new GeoLocation(GeoLocation.getIpAddrOrUnknown(ipAddress), country, city, "");
    }

    public String getWhere() {
        boolean countryPresent = StringUtility.hasLength(this.country);
        boolean cityPresent = StringUtility.hasLength(this.city);
        if (countryPresent && !cityPresent) {
            return this.country;
        }
        if (countryPresent) {
            return this.country + ", " + this.city;
        }
        return "Unknown";
    }

    public static String getIpAddrOrUnknown(IPAddress ipAddress) {
        return Objects.nonNull(ipAddress) ? ipAddress.getValue() : "Unknown";
    }

    @Generated
    public String getIpAddr() {
        return this.ipAddr;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public String getCity() {
        return this.city;
    }

    @Generated
    public String getExceptionDetails() {
        return this.exceptionDetails;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ipAddr = this.getIpAddr();
        String other$ipAddr = other.getIpAddr();
        if (this$ipAddr == null ? other$ipAddr != null : !this$ipAddr.equals(other$ipAddr)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$exceptionDetails = this.getExceptionDetails();
        String other$exceptionDetails = other.getExceptionDetails();
        return !(this$exceptionDetails == null ? other$exceptionDetails != null : !this$exceptionDetails.equals(other$exceptionDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeoLocation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ipAddr = this.getIpAddr();
        result = result * 59 + ($ipAddr == null ? 43 : $ipAddr.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $exceptionDetails = this.getExceptionDetails();
        result = result * 59 + ($exceptionDetails == null ? 43 : $exceptionDetails.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeoLocation(ipAddr=" + this.getIpAddr() + ", country=" + this.getCountry() + ", city=" + this.getCity() + ", exceptionDetails=" + this.getExceptionDetails() + ")";
    }
}

