/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.bytes;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.hardware.bytes.ByteSize;
import io.tech1.framework.domain.hardware.bytes.ByteUnit;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.math.BigDecimal;
import lombok.Generated;

public class ByteAmount {
    private final BigDecimal amount;
    private final ByteUnit unit;

    public ByteAmount(long bytes, ByteUnit unit) {
        Asserts.assertNonNullOrThrow((Object)unit, ExceptionsMessagesUtility.invalidAttribute("ByteAmount.unit"));
        this.amount = new ByteSize(bytes).getBy(unit);
        this.unit = unit;
    }

    public static ByteAmount ofGb(long bytes) {
        return new ByteAmount(bytes, ByteUnit.GIGABYTE);
    }

    public static ByteAmount ofMB(long bytes) {
        return new ByteAmount(bytes, ByteUnit.MEGABYTE);
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public ByteUnit getUnit() {
        return this.unit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteAmount)) {
            return false;
        }
        ByteAmount other = (ByteAmount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        ByteUnit this$unit = this.getUnit();
        ByteUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ByteAmount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        ByteUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ByteAmount(amount=" + this.getAmount() + ", unit=" + this.getUnit() + ")";
    }
}

