/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.bytes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.tech1.framework.domain.hardware.bytes.ByteUnit;
import io.tech1.framework.domain.utilities.numbers.RoundingUtility;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;

public final class ByteSize {
    private static final long BYTES_IN_KILOBYTE = 1024L;
    private static final long BYTES_IN_MEGABYTE = 0x100000L;
    private static final long BYTES_IN_GIGABYTE = 0x40000000L;
    private final Map<ByteUnit, Supplier<BigDecimal>> mapping1 = Map.of(ByteUnit.KILOBYTE, () -> this.getKilobytes(1), ByteUnit.MEGABYTE, () -> this.getMegabytes(1), ByteUnit.GIGABYTE, () -> this.getGigabytes(4));
    private final Map<ByteUnit, Function<Integer, BigDecimal>> mapping2 = Map.of(ByteUnit.KILOBYTE, this::getKilobytes, ByteUnit.MEGABYTE, this::getMegabytes, ByteUnit.GIGABYTE, this::getGigabytes);
    @JsonValue
    private final long bytes;

    @JsonCreator
    public ByteSize(long bytes) {
        this.bytes = bytes;
    }

    public static ByteSize kilobyte() {
        return new ByteSize(1024L);
    }

    public static ByteSize megabyte() {
        return new ByteSize(0x100000L);
    }

    public static ByteSize gigabyte() {
        return new ByteSize(0x40000000L);
    }

    public BigDecimal getBy(ByteUnit unit) {
        return this.mapping1.get((Object)unit).get();
    }

    public BigDecimal getBy(ByteUnit unit, int scale) {
        return this.mapping2.get((Object)unit).apply(scale);
    }

    private BigDecimal getKilobytes(int scale) {
        BigDecimal kb = BigDecimal.valueOf((double)this.bytes / 1024.0);
        return RoundingUtility.scale(kb, scale);
    }

    private BigDecimal getMegabytes(int scale) {
        BigDecimal mb = BigDecimal.valueOf((double)this.bytes / 1048576.0);
        return RoundingUtility.scale(mb, scale);
    }

    private BigDecimal getGigabytes(int scale) {
        BigDecimal gb = BigDecimal.valueOf((double)this.bytes / 1.073741824E9);
        return RoundingUtility.scale(gb, scale);
    }

    @Generated
    public Map<ByteUnit, Supplier<BigDecimal>> getMapping1() {
        return this.mapping1;
    }

    @Generated
    public Map<ByteUnit, Function<Integer, BigDecimal>> getMapping2() {
        return this.mapping2;
    }

    @Generated
    public long getBytes() {
        return this.bytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteSize)) {
            return false;
        }
        ByteSize other = (ByteSize)o;
        return this.getBytes() == other.getBytes();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bytes = this.getBytes();
        result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
        return result;
    }

    @Generated
    public String toString() {
        return "ByteSize(bytes=" + this.getBytes() + ")";
    }
}

