/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.monitoring;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.hardware.bytes.ByteSize;
import io.tech1.framework.domain.hardware.bytes.ByteUnit;
import io.tech1.framework.domain.hardware.memories.CpuMemory;
import io.tech1.framework.domain.hardware.memories.GlobalMemory;
import io.tech1.framework.domain.hardware.memories.HeapMemory;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringDatapointTableRow;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringDatapointTableView;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringMaxValues;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThresholds;
import io.tech1.framework.domain.hardware.monitoring.HardwareName;
import io.tech1.framework.domain.tuples.Tuple3;
import io.tech1.framework.domain.tuples.TuplePercentage;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.time.TimestampUtility;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.function.Function;
import lombok.Generated;

public class HardwareMonitoringDatapoint {
    private final ByteUnit unit;
    private final Tuple3<TuplePercentage, TuplePercentage, TuplePercentage> global;
    private final BigDecimal cpu;
    private final TuplePercentage heap;
    private final HardwareMonitoringMaxValues maxValues;
    private final long timestamp;

    public HardwareMonitoringDatapoint(GlobalMemory global, CpuMemory cpu, HeapMemory heap) {
        Asserts.assertNonNullOrThrow(global, ExceptionsMessagesUtility.invalidAttribute("MonitoringDatapoint.global"));
        Asserts.assertNonNullOrThrow(cpu, ExceptionsMessagesUtility.invalidAttribute("MonitoringDatapoint.cpu"));
        Asserts.assertNonNullOrThrow(heap, ExceptionsMessagesUtility.invalidAttribute("MonitoringDatapoint.heap"));
        this.unit = ByteUnit.GIGABYTE;
        TuplePercentage server = TuplePercentage.of(new ByteSize(global.getTotal().getBytes() - global.getAvailable().getBytes()).getBy(this.unit), global.getTotal().getBy(this.unit), 2, 1);
        TuplePercentage swap = TuplePercentage.of(global.getSwapUsed().getBy(this.unit), global.getSwapTotal().getBy(this.unit), 2, 1);
        TuplePercentage virtual = TuplePercentage.of(global.getVirtualUsed().getBy(this.unit), global.getVirtualTotal().getBy(this.unit), 2, 1);
        this.global = Tuple3.of(server, swap, virtual);
        this.cpu = cpu.getValue();
        this.heap = TuplePercentage.of(heap.getUsed().getBy(this.unit), heap.getMax().getBy(this.unit), 2, 1);
        this.maxValues = new HardwareMonitoringMaxValues(global, heap);
        this.timestamp = TimestampUtility.getCurrentTimestamp();
    }

    public static HardwareMonitoringDatapoint zeroUsage() {
        return new HardwareMonitoringDatapoint(GlobalMemory.zeroUsage(), CpuMemory.zeroUsage(), HeapMemory.zeroUsage());
    }

    public HardwareMonitoringDatapointTableView tableView(HardwareMonitoringThresholds thresholds) {
        ArrayList<HardwareMonitoringDatapointTableRow> table = new ArrayList<HardwareMonitoringDatapointTableRow>();
        table.add(new HardwareMonitoringDatapointTableRow(HardwareName.CPU, this.timestamp, this.cpu, "", thresholds));
        Function<Tuple3, HardwareMonitoringDatapointTableRow> tableRowFnc = tuple3 -> {
            HardwareName hardwareName = (HardwareName)((Object)((Object)tuple3.getA()));
            BigDecimal percentage = ((TuplePercentage)tuple3.getB()).getPercentage();
            String readableValue = ((TuplePercentage)tuple3.getB()).getValue() + " " + this.unit.getSymbol() + " of " + ((ByteSize)tuple3.getC()).getBy(this.unit, 2) + " " + this.unit.getSymbol();
            return new HardwareMonitoringDatapointTableRow(hardwareName, this.timestamp, percentage, readableValue, thresholds);
        };
        table.add(tableRowFnc.apply(Tuple3.of(HardwareName.HEAP, this.heap, this.maxValues.getHeap())));
        table.add(tableRowFnc.apply(Tuple3.of(HardwareName.SERVER, this.global.getA(), this.maxValues.getServer())));
        table.add(tableRowFnc.apply(Tuple3.of(HardwareName.SWAP, this.global.getB(), this.maxValues.getSwap())));
        table.add(tableRowFnc.apply(Tuple3.of(HardwareName.VIRTUAL, this.global.getC(), this.maxValues.getVirtual())));
        return new HardwareMonitoringDatapointTableView(table);
    }

    @Generated
    public ByteUnit getUnit() {
        return this.unit;
    }

    @Generated
    public Tuple3<TuplePercentage, TuplePercentage, TuplePercentage> getGlobal() {
        return this.global;
    }

    @Generated
    public BigDecimal getCpu() {
        return this.cpu;
    }

    @Generated
    public TuplePercentage getHeap() {
        return this.heap;
    }

    @Generated
    public HardwareMonitoringMaxValues getMaxValues() {
        return this.maxValues;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareMonitoringDatapoint)) {
            return false;
        }
        HardwareMonitoringDatapoint other = (HardwareMonitoringDatapoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        ByteUnit this$unit = this.getUnit();
        ByteUnit other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit)) {
            return false;
        }
        Tuple3<TuplePercentage, TuplePercentage, TuplePercentage> this$global = this.getGlobal();
        Tuple3<TuplePercentage, TuplePercentage, TuplePercentage> other$global = other.getGlobal();
        if (this$global == null ? other$global != null : !((Object)this$global).equals(other$global)) {
            return false;
        }
        BigDecimal this$cpu = this.getCpu();
        BigDecimal other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        TuplePercentage this$heap = this.getHeap();
        TuplePercentage other$heap = other.getHeap();
        if (this$heap == null ? other$heap != null : !((Object)this$heap).equals(other$heap)) {
            return false;
        }
        HardwareMonitoringMaxValues this$maxValues = this.getMaxValues();
        HardwareMonitoringMaxValues other$maxValues = other.getMaxValues();
        return !(this$maxValues == null ? other$maxValues != null : !((Object)this$maxValues).equals(other$maxValues));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareMonitoringDatapoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        ByteUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        Tuple3<TuplePercentage, TuplePercentage, TuplePercentage> $global = this.getGlobal();
        result = result * 59 + ($global == null ? 43 : ((Object)$global).hashCode());
        BigDecimal $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        TuplePercentage $heap = this.getHeap();
        result = result * 59 + ($heap == null ? 43 : ((Object)$heap).hashCode());
        HardwareMonitoringMaxValues $maxValues = this.getMaxValues();
        result = result * 59 + ($maxValues == null ? 43 : ((Object)$maxValues).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareMonitoringDatapoint(unit=" + this.getUnit() + ", global=" + this.getGlobal() + ", cpu=" + this.getCpu() + ", heap=" + this.getHeap() + ", maxValues=" + this.getMaxValues() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

