/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.monitoring;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringThresholds;
import io.tech1.framework.domain.hardware.monitoring.HardwareName;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.numbers.BigDecimalUtility;
import java.math.BigDecimal;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class HardwareMonitoringDatapointTableRow {
    private final HardwareName hardwareName;
    private final long timestamp;
    private final BigDecimal usage;
    private final String value;
    @JsonIgnore
    private final boolean thresholdReached;

    public HardwareMonitoringDatapointTableRow(HardwareName hardwareName, long timestamp, BigDecimal usage, String value, HardwareMonitoringThresholds thresholds) {
        Asserts.assertNonNullOrThrow((Object)hardwareName, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringDatapointTableRow.hardwareName"));
        Asserts.assertNonNullOrThrow(usage, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringDatapointTableRow.usage"));
        Asserts.assertNonNullOrThrow(value, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringDatapointTableRow.value"));
        Asserts.assertNonNullOrThrow(thresholds, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringDatapointTableRow.thresholds"));
        this.hardwareName = hardwareName;
        this.timestamp = timestamp;
        this.usage = usage;
        this.value = value;
        this.thresholdReached = !CollectionUtils.isEmpty(thresholds.getThresholds()) && thresholds.getThresholds().containsKey((Object)hardwareName) ? BigDecimalUtility.isFirstValueGreater(usage, thresholds.getThresholds().get((Object)hardwareName).getValue()) : false;
    }

    @Generated
    public HardwareName getHardwareName() {
        return this.hardwareName;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public BigDecimal getUsage() {
        return this.usage;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean isThresholdReached() {
        return this.thresholdReached;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareMonitoringDatapointTableRow)) {
            return false;
        }
        HardwareMonitoringDatapointTableRow other = (HardwareMonitoringDatapointTableRow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isThresholdReached() != other.isThresholdReached()) {
            return false;
        }
        HardwareName this$hardwareName = this.getHardwareName();
        HardwareName other$hardwareName = other.getHardwareName();
        if (this$hardwareName == null ? other$hardwareName != null : !((Object)((Object)this$hardwareName)).equals((Object)other$hardwareName)) {
            return false;
        }
        BigDecimal this$usage = this.getUsage();
        BigDecimal other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareMonitoringDatapointTableRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isThresholdReached() ? 79 : 97);
        HardwareName $hardwareName = this.getHardwareName();
        result = result * 59 + ($hardwareName == null ? 43 : ((Object)((Object)$hardwareName)).hashCode());
        BigDecimal $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareMonitoringDatapointTableRow(hardwareName=" + this.getHardwareName() + ", timestamp=" + this.getTimestamp() + ", usage=" + this.getUsage() + ", value=" + this.getValue() + ", thresholdReached=" + this.isThresholdReached() + ")";
    }
}

