/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.monitoring;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.hardware.monitoring.HardwareMonitoringDatapointTableRow;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class HardwareMonitoringDatapointTableView {
    private final List<HardwareMonitoringDatapointTableRow> rows;
    private final boolean anyPresent;
    private final boolean anyProblem;

    public HardwareMonitoringDatapointTableView(List<HardwareMonitoringDatapointTableRow> rows) {
        Asserts.assertNonNullOrThrow(rows, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringDatapointTableView.rows"));
        this.rows = rows;
        this.anyPresent = !CollectionUtils.isEmpty(this.rows);
        this.anyProblem = rows.stream().anyMatch(HardwareMonitoringDatapointTableRow::isThresholdReached);
    }

    @Generated
    public List<HardwareMonitoringDatapointTableRow> getRows() {
        return this.rows;
    }

    @Generated
    public boolean isAnyPresent() {
        return this.anyPresent;
    }

    @Generated
    public boolean isAnyProblem() {
        return this.anyProblem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareMonitoringDatapointTableView)) {
            return false;
        }
        HardwareMonitoringDatapointTableView other = (HardwareMonitoringDatapointTableView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAnyPresent() != other.isAnyPresent()) {
            return false;
        }
        if (this.isAnyProblem() != other.isAnyProblem()) {
            return false;
        }
        List<HardwareMonitoringDatapointTableRow> this$rows = this.getRows();
        List<HardwareMonitoringDatapointTableRow> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareMonitoringDatapointTableView;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAnyPresent() ? 79 : 97);
        result = result * 59 + (this.isAnyProblem() ? 79 : 97);
        List<HardwareMonitoringDatapointTableRow> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareMonitoringDatapointTableView(rows=" + this.getRows() + ", anyPresent=" + this.isAnyPresent() + ", anyProblem=" + this.isAnyProblem() + ")";
    }
}

