/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.hardware.monitoring;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.hardware.bytes.ByteSize;
import io.tech1.framework.domain.hardware.memories.GlobalMemory;
import io.tech1.framework.domain.hardware.memories.HeapMemory;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import lombok.Generated;

public class HardwareMonitoringMaxValues {
    private final ByteSize server;
    private final ByteSize swap;
    private final ByteSize virtual;
    private final ByteSize heap;

    public HardwareMonitoringMaxValues(GlobalMemory global, HeapMemory heap) {
        Asserts.assertNonNullOrThrow(global, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringMaxValues.global"));
        Asserts.assertNonNullOrThrow(heap, ExceptionsMessagesUtility.invalidAttribute("HardwareMonitoringMaxValues.heap"));
        this.server = global.getTotal();
        this.swap = global.getSwapTotal();
        this.virtual = global.getVirtualTotal();
        this.heap = heap.getMax();
    }

    @Generated
    public ByteSize getServer() {
        return this.server;
    }

    @Generated
    public ByteSize getSwap() {
        return this.swap;
    }

    @Generated
    public ByteSize getVirtual() {
        return this.virtual;
    }

    @Generated
    public ByteSize getHeap() {
        return this.heap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardwareMonitoringMaxValues)) {
            return false;
        }
        HardwareMonitoringMaxValues other = (HardwareMonitoringMaxValues)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteSize this$server = this.getServer();
        ByteSize other$server = other.getServer();
        if (this$server == null ? other$server != null : !((Object)this$server).equals(other$server)) {
            return false;
        }
        ByteSize this$swap = this.getSwap();
        ByteSize other$swap = other.getSwap();
        if (this$swap == null ? other$swap != null : !((Object)this$swap).equals(other$swap)) {
            return false;
        }
        ByteSize this$virtual = this.getVirtual();
        ByteSize other$virtual = other.getVirtual();
        if (this$virtual == null ? other$virtual != null : !((Object)this$virtual).equals(other$virtual)) {
            return false;
        }
        ByteSize this$heap = this.getHeap();
        ByteSize other$heap = other.getHeap();
        return !(this$heap == null ? other$heap != null : !((Object)this$heap).equals(other$heap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HardwareMonitoringMaxValues;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteSize $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : ((Object)$server).hashCode());
        ByteSize $swap = this.getSwap();
        result = result * 59 + ($swap == null ? 43 : ((Object)$swap).hashCode());
        ByteSize $virtual = this.getVirtual();
        result = result * 59 + ($virtual == null ? 43 : ((Object)$virtual).hashCode());
        ByteSize $heap = this.getHeap();
        result = result * 59 + ($heap == null ? 43 : ((Object)$heap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HardwareMonitoringMaxValues(server=" + this.getServer() + ", swap=" + this.getSwap() + ", virtual=" + this.getVirtual() + ", heap=" + this.getHeap() + ")";
    }
}

