/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.http.requests;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.tech1.framework.domain.enums.Status;
import io.tech1.framework.domain.geo.GeoLocation;
import io.tech1.framework.domain.http.requests.IPAddress;
import io.tech1.framework.domain.http.requests.UserAgentDetails;
import io.tech1.framework.domain.tuples.Tuple2;
import io.tech1.framework.domain.tuples.Tuple3;
import io.tech1.framework.domain.tuples.TupleExceptionDetails;
import io.tech1.framework.domain.utilities.strings.StringUtility;
import java.beans.ConstructorProperties;
import lombok.Generated;

@JsonPropertyOrder(value={"status", "geoLocation", "userAgentDetails", "whereTuple3", "whatTuple2", "exception"})
public class UserRequestMetadata {
    private final Status status;
    private final GeoLocation geoLocation;
    private final UserAgentDetails userAgentDetails;

    public static UserRequestMetadata processing(IPAddress ipAddress) {
        return new UserRequestMetadata(Status.STARTED, GeoLocation.processing(ipAddress), UserAgentDetails.processing());
    }

    public static UserRequestMetadata processed(GeoLocation geoLocation, UserAgentDetails userAgentDetails) {
        return new UserRequestMetadata(Status.COMPLETED, geoLocation, userAgentDetails);
    }

    public Tuple3<String, String, String> getWhereTuple3() {
        if (this.status.isCompleted()) {
            return Tuple3.of(this.geoLocation.getIpAddr(), this.geoLocation.getCountry(), this.geoLocation.getWhere());
        }
        return Tuple3.of(this.geoLocation.getIpAddr(), "[?]", "Processing...Please wait!");
    }

    public Tuple2<String, String> getWhatTuple2() {
        if (this.status.isCompleted()) {
            return Tuple2.of(this.userAgentDetails.getBrowser(), this.userAgentDetails.getWhat());
        }
        return Tuple2.of(this.userAgentDetails.getBrowser(), "\u2014");
    }

    public TupleExceptionDetails getException() {
        String geoExceptionDetails = this.geoLocation.getExceptionDetails();
        String userAgentExceptionDetails = this.userAgentDetails.getExceptionDetails();
        if (StringUtility.hasLength(geoExceptionDetails) && StringUtility.hasLength(userAgentExceptionDetails)) {
            return TupleExceptionDetails.exception(geoExceptionDetails + ". " + userAgentExceptionDetails);
        }
        if (StringUtility.hasLength(geoExceptionDetails)) {
            return TupleExceptionDetails.exception(geoExceptionDetails);
        }
        if (StringUtility.hasLength(userAgentExceptionDetails)) {
            return TupleExceptionDetails.exception(userAgentExceptionDetails);
        }
        return TupleExceptionDetails.ok();
    }

    @ConstructorProperties(value={"status", "geoLocation", "userAgentDetails"})
    @Generated
    private UserRequestMetadata(Status status, GeoLocation geoLocation, UserAgentDetails userAgentDetails) {
        this.status = status;
        this.geoLocation = geoLocation;
        this.userAgentDetails = userAgentDetails;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Generated
    public UserAgentDetails getUserAgentDetails() {
        return this.userAgentDetails;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRequestMetadata)) {
            return false;
        }
        UserRequestMetadata other = (UserRequestMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        GeoLocation this$geoLocation = this.getGeoLocation();
        GeoLocation other$geoLocation = other.getGeoLocation();
        if (this$geoLocation == null ? other$geoLocation != null : !((Object)this$geoLocation).equals(other$geoLocation)) {
            return false;
        }
        UserAgentDetails this$userAgentDetails = this.getUserAgentDetails();
        UserAgentDetails other$userAgentDetails = other.getUserAgentDetails();
        return !(this$userAgentDetails == null ? other$userAgentDetails != null : !((Object)this$userAgentDetails).equals(other$userAgentDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserRequestMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        GeoLocation $geoLocation = this.getGeoLocation();
        result = result * 59 + ($geoLocation == null ? 43 : ((Object)$geoLocation).hashCode());
        UserAgentDetails $userAgentDetails = this.getUserAgentDetails();
        result = result * 59 + ($userAgentDetails == null ? 43 : ((Object)$userAgentDetails).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserRequestMetadata(status=" + this.getStatus() + ", geoLocation=" + this.getGeoLocation() + ", userAgentDetails=" + this.getUserAgentDetails() + ")";
    }
}

