/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.notifications;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.notifications.NotificationType;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import lombok.Generated;

public class Notification {
    @JsonProperty(value="nt")
    private final NotificationType notificationType;
    @JsonProperty(value="m")
    private final String message;

    public Notification(NotificationType notificationType, String message) {
        Asserts.assertNonNullOrThrow((Object)notificationType, ExceptionsMessagesUtility.invalidAttribute("Notification.notificationType"));
        Asserts.assertNonNullOrThrow(message, ExceptionsMessagesUtility.invalidAttribute("Notification.message"));
        this.notificationType = notificationType;
        this.message = message;
    }

    public static Notification info(String message) {
        return new Notification(NotificationType.INFO, message);
    }

    public static Notification success(String message) {
        return new Notification(NotificationType.SUCCESS, message);
    }

    public static Notification warning(String message) {
        return new Notification(NotificationType.WARNING, message);
    }

    public static Notification error(String message) {
        return new Notification(NotificationType.ERROR, message);
    }

    @Generated
    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Notification)) {
            return false;
        }
        Notification other = (Notification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NotificationType this$notificationType = this.getNotificationType();
        NotificationType other$notificationType = other.getNotificationType();
        if (this$notificationType == null ? other$notificationType != null : !((Object)((Object)this$notificationType)).equals((Object)other$notificationType)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Notification;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NotificationType $notificationType = this.getNotificationType();
        result = result * 59 + ($notificationType == null ? 43 : ((Object)((Object)$notificationType)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Notification(notificationType=" + this.getNotificationType() + ", message=" + this.getMessage() + ")";
    }
}

