/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.properties.base;

import io.tech1.framework.domain.properties.annotations.MandatoryProperty;
import io.tech1.framework.domain.properties.annotations.NonMandatoryProperty;
import java.util.Objects;
import lombok.Generated;

public class Mongodb {
    @MandatoryProperty
    private String host;
    @MandatoryProperty
    private int port;
    @MandatoryProperty
    private String database;
    @NonMandatoryProperty
    private String username;
    @NonMandatoryProperty
    private String password;

    public static Mongodb of(String host, int port, String database) {
        Mongodb instance = new Mongodb();
        instance.host = host;
        instance.port = port;
        instance.database = database;
        return instance;
    }

    public final String connectionString() {
        if (this.isAuthenticationRequired()) {
            return "mongodb://" + this.username + ":" + this.password + "@" + this.host + ":" + this.port + "/" + this.database;
        }
        return "mongodb://" + this.host + ":" + this.port + "/" + this.database;
    }

    private boolean isAuthenticationRequired() {
        return Objects.nonNull(this.username) && Objects.nonNull(this.password);
    }

    @Generated
    public Mongodb() {
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Mongodb)) {
            return false;
        }
        Mongodb other = (Mongodb)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Mongodb;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Mongodb(host=" + this.getHost() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

