/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.properties.configs;

import io.tech1.framework.domain.properties.annotations.MandatoryProperty;
import io.tech1.framework.domain.properties.annotations.NonMandatoryProperty;
import io.tech1.framework.domain.properties.base.RemoteServer;
import io.tech1.framework.domain.properties.configs.AbstractPropertiesToggleConfigs;
import io.tech1.framework.domain.properties.configs.incidents.AbstractIncidentFeatureConfigs;
import io.tech1.framework.domain.properties.configs.incidents.IncidentFeatureConfigs;
import io.tech1.framework.domain.properties.configs.incidents.IncidentFeaturesConfigs;
import java.util.Objects;
import lombok.Generated;

public class IncidentConfigs
extends AbstractPropertiesToggleConfigs
implements AbstractIncidentFeatureConfigs {
    @MandatoryProperty
    private boolean enabled;
    @NonMandatoryProperty
    private RemoteServer remoteServer;
    @NonMandatoryProperty
    private IncidentFeaturesConfigs features;

    public static IncidentConfigs of(boolean enabled, RemoteServer remoteServer, IncidentFeaturesConfigs features) {
        IncidentConfigs instance = new IncidentConfigs();
        instance.enabled = enabled;
        instance.remoteServer = remoteServer;
        instance.features = features;
        return instance;
    }

    public static IncidentConfigs disabled() {
        IncidentConfigs instance = new IncidentConfigs();
        instance.enabled = false;
        return instance;
    }

    @Override
    public void assertProperties() {
        super.assertProperties();
        IncidentFeatureConfigs loginFailureUsernamePassword = this.features.getLoginFailureUsernamePassword();
        IncidentFeatureConfigs loginFailureUsernameMaskedPassword = this.features.getLoginFailureUsernameMaskedPassword();
        if (Boolean.TRUE.equals(loginFailureUsernamePassword.isEnabled()) && Boolean.TRUE.equals(loginFailureUsernameMaskedPassword.isEnabled())) {
            throw new IllegalArgumentException("Please configure login failure incident feature. Only one feature type could be enabled");
        }
    }

    @Override
    public void configureRequiredIncidentsIfMissing() {
        if (Objects.isNull(this.features)) {
            this.features = new IncidentFeaturesConfigs();
        }
        this.features.configureRequiredIncidentsIfMissing();
    }

    @Generated
    public IncidentConfigs() {
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public RemoteServer getRemoteServer() {
        return this.remoteServer;
    }

    @Generated
    public IncidentFeaturesConfigs getFeatures() {
        return this.features;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setRemoteServer(RemoteServer remoteServer) {
        this.remoteServer = remoteServer;
    }

    @Generated
    public void setFeatures(IncidentFeaturesConfigs features) {
        this.features = features;
    }

    @Generated
    public String toString() {
        return "IncidentConfigs(enabled=" + this.isEnabled() + ", remoteServer=" + this.getRemoteServer() + ", features=" + this.getFeatures() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncidentConfigs)) {
            return false;
        }
        IncidentConfigs other = (IncidentConfigs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        RemoteServer this$remoteServer = this.getRemoteServer();
        RemoteServer other$remoteServer = other.getRemoteServer();
        if (this$remoteServer == null ? other$remoteServer != null : !((Object)this$remoteServer).equals(other$remoteServer)) {
            return false;
        }
        IncidentFeaturesConfigs this$features = this.getFeatures();
        IncidentFeaturesConfigs other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IncidentConfigs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        RemoteServer $remoteServer = this.getRemoteServer();
        result = result * 59 + ($remoteServer == null ? 43 : ((Object)$remoteServer).hashCode());
        IncidentFeaturesConfigs $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        return result;
    }
}

