/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.properties.configs.security.jwt;

import io.tech1.framework.domain.properties.annotations.MandatoryProperty;
import io.tech1.framework.domain.properties.base.Authority;
import io.tech1.framework.domain.properties.configs.AbstractPropertiesConfigs;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class AuthoritiesConfigs
extends AbstractPropertiesConfigs {
    @MandatoryProperty
    private String packageName;
    @MandatoryProperty
    private Set<Authority> authorities;

    public static AuthoritiesConfigs of(String packageName, Set<Authority> authorities) {
        AuthoritiesConfigs instance = new AuthoritiesConfigs();
        instance.packageName = packageName;
        instance.authorities = authorities;
        return instance;
    }

    public Set<String> getAllAuthoritiesValues() {
        return this.authorities.stream().map(Authority::getValue).collect(Collectors.toSet());
    }

    public Set<String> getAvailableAuthorities() {
        return this.authorities.stream().map(Authority::getValue).filter(authority -> !"superadmin".equals(authority)).collect(Collectors.toSet());
    }

    @Generated
    public AuthoritiesConfigs() {
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public Set<Authority> getAuthorities() {
        return this.authorities;
    }

    @Generated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Generated
    public void setAuthorities(Set<Authority> authorities) {
        this.authorities = authorities;
    }

    @Generated
    public String toString() {
        return "AuthoritiesConfigs(packageName=" + this.getPackageName() + ", authorities=" + this.getAuthorities() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthoritiesConfigs)) {
            return false;
        }
        AuthoritiesConfigs other = (AuthoritiesConfigs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        Set<Authority> this$authorities = this.getAuthorities();
        Set<Authority> other$authorities = other.getAuthorities();
        return !(this$authorities == null ? other$authorities != null : !((Object)this$authorities).equals(other$authorities));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthoritiesConfigs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        Set<Authority> $authorities = this.getAuthorities();
        result = result * 59 + ($authorities == null ? 43 : ((Object)$authorities).hashCode());
        return result;
    }
}

