/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.properties.utilities;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.properties.annotations.MandatoryProperty;
import io.tech1.framework.domain.properties.annotations.NonMandatoryProperty;
import io.tech1.framework.domain.properties.configs.AbstractPropertiesConfigs;
import io.tech1.framework.domain.reflections.ReflectionProperty;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.reflections.ReflectionUtility;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public final class PropertiesAsserter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesAsserter.class);
    private static final Map<Function<Class<?>, Boolean>, Consumer<ReflectionProperty>> ACTIONS = new HashMap();

    public static void assertProperties(AbstractPropertiesConfigs abstractConfigs, String parentName) {
        Asserts.assertNonNullOrThrow(abstractConfigs, ExceptionsMessagesUtility.invalidAttribute(parentName));
        abstractConfigs.assertProperties();
    }

    public static void assertNotNullProperties(AbstractPropertiesConfigs abstractConfigs, String parentName) {
        List<Method> getters = PropertiesAsserter.getGetters(abstractConfigs, parentName, Collections.emptyList());
        PropertiesAsserter.verifyProperties(getters, abstractConfigs, parentName, Collections.emptyList());
    }

    private static void verifyProperties(List<Method> getters, Object property, String parentName, List<String> projection) {
        getters.forEach(getter -> {
            String attribute = StringUtils.uncapitalize((String)getter.getName().replace("get", "").replace("is", ""));
            String attributeName = parentName + "." + attribute;
            try {
                Object getterValue = getter.invoke(property, new Object[0]);
                PropertiesAsserter.innerClass(getterValue, attributeName, projection);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Unexpected. Attribute: " + attributeName);
            }
        });
    }

    private static void innerClass(Object property, String attributeName, List<String> projection) {
        Asserts.assertNonNullOrThrow(property, ExceptionsMessagesUtility.invalidAttribute(attributeName));
        Class<?> propertyClass = property.getClass();
        Optional<Consumer> consumerOpt = ACTIONS.entrySet().stream().filter(entry -> (Boolean)((Function)entry.getKey()).apply(propertyClass)).map(Map.Entry::getValue).findFirst();
        if (consumerOpt.isPresent()) {
            ReflectionProperty reflectionProperty = ReflectionProperty.of(propertyClass.getSimpleName(), attributeName, property);
            consumerOpt.get().accept(reflectionProperty);
        } else {
            List<Method> getters = PropertiesAsserter.getGetters(property, attributeName, projection);
            PropertiesAsserter.verifyProperties(getters, property, attributeName, projection);
        }
    }

    private static List<Method> getGetters(Object property, String attributeName, List<String> skipProjection) {
        Asserts.assertNonNullOrThrow(property, ExceptionsMessagesUtility.invalidAttribute(attributeName));
        return ReflectionUtility.getGetters(property).stream().filter(Objects::nonNull).filter(method -> !method.getName().equals("getOrder")).filter(method -> {
            try {
                String fieldName = StringUtils.uncapitalize((String)method.getName().replace("get", "").replace("is", ""));
                Field declaredField = property.getClass().getDeclaredField(fieldName);
                return declaredField.isAnnotationPresent(MandatoryProperty.class) && !declaredField.isAnnotationPresent(NonMandatoryProperty.class);
            }
            catch (NoSuchFieldException e) {
                return true;
            }
        }).filter(method -> {
            String lowerCaseAttribute = method.getName().toLowerCase().replace("get", "");
            return !skipProjection.contains(lowerCaseAttribute);
        }).collect(Collectors.toList());
    }

    @Generated
    private PropertiesAsserter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ACTIONS.put(Date.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(LocalDate.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(LocalDateTime.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(ChronoUnit.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(TimeUnit.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(Boolean.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(Short.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(Integer.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(Long.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(BigInteger.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(BigDecimal.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(String.class::equals, Asserts::assertNonNullPropertyOrThrow);
        ACTIONS.put(Collection.class::isAssignableFrom, cp -> Asserts.assertNonNullNotEmptyOrThrow((Collection)cp.getPropertyValue(), ExceptionsMessagesUtility.invalidAttribute(cp.getPropertyName())));
    }
}

