/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.reflections;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.springframework.util.StringUtils;

public class ReflectionProperty {
    private final String parentPropertyName;
    private final String propertyName;
    private final Object propertyValue;
    private final String readableValue;

    public ReflectionProperty(String parentPropertyName, String propertyName, Object propertyValue) {
        Asserts.assertNonNullOrThrow(parentPropertyName, ExceptionsMessagesUtility.invalidAttribute("ReflectionProperty.parentPropertyName"));
        Asserts.assertNonNullOrThrow(propertyName, ExceptionsMessagesUtility.invalidAttribute("ReflectionProperty.propertyName"));
        this.parentPropertyName = parentPropertyName;
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        boolean isArray = Objects.nonNull(this.propertyValue) && this.propertyValue.getClass().isArray();
        this.readableValue = isArray ? String.format("%s.%s: `%s`", StringUtils.uncapitalize((String)parentPropertyName), StringUtils.uncapitalize((String)this.propertyName), Arrays.toString((String[])this.propertyValue)) : String.format("%s.%s: `%s`", StringUtils.uncapitalize((String)parentPropertyName), StringUtils.uncapitalize((String)this.propertyName), this.propertyValue);
    }

    public static ReflectionProperty of(String parentPropertyName, String propertyName, Object propertyValue) {
        return new ReflectionProperty(parentPropertyName, propertyName, propertyValue);
    }

    @Generated
    public String getParentPropertyName() {
        return this.parentPropertyName;
    }

    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @Generated
    public Object getPropertyValue() {
        return this.propertyValue;
    }

    @Generated
    public String getReadableValue() {
        return this.readableValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReflectionProperty)) {
            return false;
        }
        ReflectionProperty other = (ReflectionProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$parentPropertyName = this.getParentPropertyName();
        String other$parentPropertyName = other.getParentPropertyName();
        if (this$parentPropertyName == null ? other$parentPropertyName != null : !this$parentPropertyName.equals(other$parentPropertyName)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        Object this$propertyValue = this.getPropertyValue();
        Object other$propertyValue = other.getPropertyValue();
        if (this$propertyValue == null ? other$propertyValue != null : !this$propertyValue.equals(other$propertyValue)) {
            return false;
        }
        String this$readableValue = this.getReadableValue();
        String other$readableValue = other.getReadableValue();
        return !(this$readableValue == null ? other$readableValue != null : !this$readableValue.equals(other$readableValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReflectionProperty;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parentPropertyName = this.getParentPropertyName();
        result = result * 59 + ($parentPropertyName == null ? 43 : $parentPropertyName.hashCode());
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        Object $propertyValue = this.getPropertyValue();
        result = result * 59 + ($propertyValue == null ? 43 : $propertyValue.hashCode());
        String $readableValue = this.getReadableValue();
        result = result * 59 + ($readableValue == null ? 43 : $readableValue.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReflectionProperty(parentPropertyName=" + this.getParentPropertyName() + ", propertyName=" + this.getPropertyName() + ", propertyValue=" + this.getPropertyValue() + ", readableValue=" + this.getReadableValue() + ")";
    }
}

