/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.tests.constants;

import io.tech1.framework.domain.hardware.monitoring.HardwareName;
import io.tech1.framework.domain.properties.base.Authority;
import io.tech1.framework.domain.properties.base.Cron;
import io.tech1.framework.domain.properties.base.DefaultUser;
import io.tech1.framework.domain.properties.base.DefaultUsers;
import io.tech1.framework.domain.properties.base.InvitationCodes;
import io.tech1.framework.domain.properties.base.JwtToken;
import io.tech1.framework.domain.properties.base.Mongodb;
import io.tech1.framework.domain.properties.base.RemoteServer;
import io.tech1.framework.domain.properties.base.TimeAmount;
import io.tech1.framework.domain.properties.configs.AsyncConfigs;
import io.tech1.framework.domain.properties.configs.EmailConfigs;
import io.tech1.framework.domain.properties.configs.EventsConfigs;
import io.tech1.framework.domain.properties.configs.HardwareMonitoringConfigs;
import io.tech1.framework.domain.properties.configs.HardwareServerConfigs;
import io.tech1.framework.domain.properties.configs.IncidentConfigs;
import io.tech1.framework.domain.properties.configs.MvcConfigs;
import io.tech1.framework.domain.properties.configs.SecurityJwtConfigs;
import io.tech1.framework.domain.properties.configs.SecurityJwtWebsocketsConfigs;
import io.tech1.framework.domain.properties.configs.incidents.IncidentFeatureConfigs;
import io.tech1.framework.domain.properties.configs.incidents.IncidentFeaturesConfigs;
import io.tech1.framework.domain.properties.configs.mvc.CorsConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.AuthoritiesConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.CookiesConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.EssenceConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.JwtTokensConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.LoggingConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.SessionConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.websockets.CsrfConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.websockets.MessageBrokerRegistryConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.websockets.StompEndpointRegistryConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.websockets.WebsocketsFeatureHardwareConfigs;
import io.tech1.framework.domain.properties.configs.security.jwt.websockets.WebsocketsFeaturesConfigs;
import io.tech1.framework.domain.utilities.random.RandomUtility;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public final class TestsPropertiesConstants {
    public static final AsyncConfigs ASYNC_CONFIGS = AsyncConfigs.of("tech1-async");
    public static final EventsConfigs EVENTS_CONFIGS = EventsConfigs.of("tech1-events");
    public static final MvcConfigs MVC_CONFIGS = MvcConfigs.of(true, "/framework/security", CorsConfigs.of("/api/**", new String[]{"http://localhost:8080", "http://localhost:8081"}, new String[]{"GET", "POST"}, new String[]{"Access-Control-Allow-Origin"}, true, null));
    public static final EmailConfigs EMAIL_CONFIGS = EmailConfigs.of(false, "smtp.gmail.com", 587, "tech1@gmail.com", "Tech1", "Password123!", new String[]{RandomUtility.randomEmail(), RandomUtility.randomEmail()});
    public static final IncidentConfigs INCIDENT_CONFIGS = IncidentConfigs.of(true, RemoteServer.of("http://localhost:8973", "incident-user", "incident-password"), IncidentFeaturesConfigs.of(IncidentFeatureConfigs.enabledIncidentFeatureConfigs(), IncidentFeatureConfigs.disabledIncidentFeatureConfigs(), IncidentFeatureConfigs.enabledIncidentFeatureConfigs(), IncidentFeatureConfigs.disabledIncidentFeatureConfigs(), IncidentFeatureConfigs.enabledIncidentFeatureConfigs(), IncidentFeatureConfigs.disabledIncidentFeatureConfigs(), IncidentFeatureConfigs.enabledIncidentFeatureConfigs(), IncidentFeatureConfigs.disabledIncidentFeatureConfigs()));
    public static final HardwareMonitoringConfigs HARDWARE_MONITORING_CONFIGS = HardwareMonitoringConfigs.of(Map.of(HardwareName.CPU, new BigDecimal("80"), HardwareName.HEAP, new BigDecimal("85"), HardwareName.SERVER, new BigDecimal("90"), HardwareName.SWAP, new BigDecimal("95"), HardwareName.VIRTUAL, new BigDecimal("98")));
    public static final HardwareServerConfigs HARDWARE_SERVER_CONFIGS = HardwareServerConfigs.of("http://localhost:8484");
    public static final SecurityJwtConfigs SECURITY_JWT_CONFIGS = SecurityJwtConfigs.of(AuthoritiesConfigs.of("io.tech1", Set.of(Authority.of("superadmin"), Authority.of("admin"), Authority.of("user"), Authority.of("invitationCode:read"), Authority.of("invitationCode:write"))), CookiesConfigs.of("tech1.io", TimeAmount.of(5L, ChronoUnit.SECONDS)), EssenceConfigs.of(DefaultUsers.of(true, List.of(DefaultUser.of("admin12", "password12", ZoneId.systemDefault(), List.of("admin")))), InvitationCodes.of(true)), JwtTokensConfigs.of("TECH1", JwtToken.of("ajwt", TimeAmount.of(30L, ChronoUnit.SECONDS)), JwtToken.of("rjwt", TimeAmount.of(12L, ChronoUnit.HOURS))), LoggingConfigs.of(true), Mongodb.of("127.0.0.1", 27017, "tech1_framework_server"), SessionConfigs.of(Cron.of(false, "*/30 * * * * *", "Europe/Kiev")));
    public static final SecurityJwtWebsocketsConfigs SECURITY_JWT_WEBSOCKETS_CONFIGS = SecurityJwtWebsocketsConfigs.of(CsrfConfigs.of("csrf-cookie", "csrf-header", "csrf-parameter"), StompEndpointRegistryConfigs.of("/endpoint"), MessageBrokerRegistryConfigs.of("/app", "/queue", "/user"), WebsocketsFeaturesConfigs.of(WebsocketsFeatureHardwareConfigs.of(true, "/account")));

    @Generated
    private TestsPropertiesConstants() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

