/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.time;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class SchedulerConfiguration {
    private final long initialDelay;
    private final long delay;
    private final TimeUnit unit;
    private final long delayedSeconds;

    @JsonCreator
    public SchedulerConfiguration(@JsonProperty(value="initialDelay") long initialDelay, @JsonProperty(value="delay") long delay, @JsonProperty(value="unit") TimeUnit unit) {
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.unit = unit;
        this.delayedSeconds = this.unit.toSeconds(this.delay);
    }

    public static SchedulerConfiguration of(long initialDelay, long delay, TimeUnit unit) {
        return new SchedulerConfiguration(initialDelay, delay, unit);
    }

    public static SchedulerConfiguration never() {
        return SchedulerConfiguration.of(Long.MAX_VALUE, Long.MAX_VALUE, TimeUnit.DAYS);
    }

    @Generated
    public long getInitialDelay() {
        return this.initialDelay;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }

    @Generated
    public TimeUnit getUnit() {
        return this.unit;
    }

    @Generated
    public long getDelayedSeconds() {
        return this.delayedSeconds;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulerConfiguration)) {
            return false;
        }
        SchedulerConfiguration other = (SchedulerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialDelay() != other.getInitialDelay()) {
            return false;
        }
        if (this.getDelay() != other.getDelay()) {
            return false;
        }
        if (this.getDelayedSeconds() != other.getDelayedSeconds()) {
            return false;
        }
        TimeUnit this$unit = this.getUnit();
        TimeUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)((Object)this$unit)).equals((Object)other$unit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SchedulerConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialDelay = this.getInitialDelay();
        result = result * 59 + (int)($initialDelay >>> 32 ^ $initialDelay);
        long $delay = this.getDelay();
        result = result * 59 + (int)($delay >>> 32 ^ $delay);
        long $delayedSeconds = this.getDelayedSeconds();
        result = result * 59 + (int)($delayedSeconds >>> 32 ^ $delayedSeconds);
        TimeUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)((Object)$unit)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SchedulerConfiguration(initialDelay=" + this.getInitialDelay() + ", delay=" + this.getDelay() + ", unit=" + this.getUnit() + ", delayedSeconds=" + this.getDelayedSeconds() + ")";
    }
}

