/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.time;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.tech1.framework.domain.tuples.Tuple2;
import io.tech1.framework.domain.utilities.strings.StringUtility;
import io.tech1.framework.domain.utilities.time.TimestampUtility;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class TimeAgo {
    public static final List<Tuple2<Long, String>> UNITS = List.of(Tuple2.of(TimeUnit.DAYS.toMillis(365L), "year"), Tuple2.of(TimeUnit.DAYS.toMillis(30L), "month"), Tuple2.of(TimeUnit.DAYS.toMillis(1L), "day"), Tuple2.of(TimeUnit.HOURS.toMillis(1L), "hour"), Tuple2.of(TimeUnit.MINUTES.toMillis(1L), "minute"), Tuple2.of(TimeUnit.SECONDS.toMillis(1L), "second"));
    @JsonValue
    private final String value;

    @JsonCreator
    public TimeAgo(long timestamp) {
        String ago;
        long duration = TimestampUtility.getCurrentTimestamp() - timestamp;
        StringBuilder agoSb = new StringBuilder();
        for (Tuple2<Long, String> unit : UNITS) {
            Long current = unit.getA();
            long temp = duration / current;
            if (temp <= 0L) continue;
            agoSb.append(temp);
            agoSb.append(" ");
            agoSb.append(unit.getB());
            agoSb.append(temp != 1L ? "s" : "");
            agoSb.append(" ");
            agoSb.append("ago");
            break;
        }
        this.value = StringUtility.isNullOrBlank(ago = agoSb.toString()) ? "just now" : ago;
    }

    public static TimeAgo of(long timestamp) {
        return new TimeAgo(timestamp);
    }

    public String toString() {
        return this.value;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeAgo)) {
            return false;
        }
        TimeAgo other = (TimeAgo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeAgo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

