/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.time;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

public class TimeAmount {
    private final long amount;
    private final ChronoUnit unit;

    @JsonCreator
    public TimeAmount(@JsonProperty(value="amount") long amount, @JsonProperty(value="unit") ChronoUnit unit) {
        Asserts.assertNonNullOrThrow(unit, ExceptionsMessagesUtility.invalidAttribute("TimeAmount.unit"));
        this.amount = amount;
        this.unit = unit;
    }

    public static TimeAmount of(long amount, ChronoUnit unit) {
        return new TimeAmount(amount, unit);
    }

    public long toSeconds() {
        return this.amount * this.getUnit().getDuration().toSeconds();
    }

    public long toMillis() {
        return this.amount * this.getUnit().getDuration().toMillis();
    }

    @Generated
    public long getAmount() {
        return this.amount;
    }

    @Generated
    public ChronoUnit getUnit() {
        return this.unit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeAmount)) {
            return false;
        }
        TimeAmount other = (TimeAmount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        ChronoUnit this$unit = this.getUnit();
        ChronoUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeAmount;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        ChronoUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeAmount(amount=" + this.getAmount() + ", unit=" + this.getUnit() + ")";
    }
}

