/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.triggers;

import com.fasterxml.jackson.annotation.JsonValue;
import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.base.Username;
import io.tech1.framework.domain.triggers.AbstractTrigger;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import lombok.Generated;

public class UserTrigger
implements AbstractTrigger {
    private final Username username;

    public UserTrigger(Username username) {
        Asserts.assertNonNullOrThrow(username, ExceptionsMessagesUtility.invalidAttribute("UserTrigger.username"));
        this.username = username;
    }

    @Override
    public String getTriggerType() {
        return "User";
    }

    @Override
    @JsonValue
    public String getReadableDetails() {
        return this.getTriggerType() + " \u2014 " + this.username;
    }

    @Generated
    public Username getUsername() {
        return this.username;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTrigger)) {
            return false;
        }
        UserTrigger other = (UserTrigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Username this$username = this.getUsername();
        Username other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !((Object)this$username).equals(other$username));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Username $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserTrigger(username=" + this.getUsername() + ")";
    }
}

