/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.tuples;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.constants.BigDecimalConstants;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.numbers.RoundingUtility;
import java.math.BigDecimal;
import lombok.Generated;

public class TuplePercentage {
    private final BigDecimal value;
    private final BigDecimal percentage;

    private TuplePercentage(BigDecimal value, BigDecimal percentage) {
        Asserts.assertNonNullOrThrow(value, ExceptionsMessagesUtility.invalidAttribute("TuplePercentage.value"));
        Asserts.assertNonNullOrThrow(percentage, ExceptionsMessagesUtility.invalidAttribute("TuplePercentage.percentage"));
        this.value = value;
        this.percentage = percentage;
    }

    public static TuplePercentage of(BigDecimal value, BigDecimal maxValue, int valueScale, int percentageScale) {
        return new TuplePercentage(RoundingUtility.scale(value, valueScale), RoundingUtility.divideOrZero(value.abs().multiply(BigDecimalConstants.ONE_HUNDRED), maxValue, percentageScale));
    }

    public static TuplePercentage progressTuplePercentage(BigDecimal value, BigDecimal maxValue) {
        return TuplePercentage.of(value, maxValue, 2, 2);
    }

    public static TuplePercentage zero() {
        return TuplePercentage.progressTuplePercentage(BigDecimal.ZERO, BigDecimalConstants.ONE_HUNDRED);
    }

    public static TuplePercentage oneHundred() {
        return TuplePercentage.progressTuplePercentage(BigDecimalConstants.ONE_HUNDRED, BigDecimalConstants.ONE_HUNDRED);
    }

    @Generated
    public BigDecimal getValue() {
        return this.value;
    }

    @Generated
    public BigDecimal getPercentage() {
        return this.percentage;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TuplePercentage)) {
            return false;
        }
        TuplePercentage other = (TuplePercentage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        BigDecimal this$percentage = this.getPercentage();
        BigDecimal other$percentage = other.getPercentage();
        return !(this$percentage == null ? other$percentage != null : !((Object)this$percentage).equals(other$percentage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TuplePercentage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        BigDecimal $percentage = this.getPercentage();
        result = result * 59 + ($percentage == null ? 43 : ((Object)$percentage).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TuplePercentage(value=" + this.getValue() + ", percentage=" + this.getPercentage() + ")";
    }
}

