/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.tuples;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class TupleRange<T> {
    private final T from;
    private final T to;

    public static <T> TupleRange<T> of(T from, T to) {
        Asserts.assertNonNullOrThrow(from, ExceptionsMessagesUtility.invalidAttribute("TupleRange.from"));
        Asserts.assertNonNullOrThrow(to, ExceptionsMessagesUtility.invalidAttribute("TupleRange.to"));
        return new TupleRange<T>(from, to);
    }

    @ConstructorProperties(value={"from", "to"})
    @Generated
    private TupleRange(T from, T to) {
        this.from = from;
        this.to = to;
    }

    @Generated
    public T getFrom() {
        return this.from;
    }

    @Generated
    public T getTo() {
        return this.to;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleRange)) {
            return false;
        }
        TupleRange other = (TupleRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$from = this.getFrom();
        T other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        T this$to = this.getTo();
        T other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TupleRange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        T $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TupleRange(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

