/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.tuples;

import io.tech1.framework.domain.asserts.Asserts;
import io.tech1.framework.domain.utilities.exceptions.ExceptionsMessagesUtility;
import io.tech1.framework.domain.utilities.time.LocalDateTimeUtility;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import lombok.Generated;

public class TupleSmartTimestamp {
    private final long timestamp;
    private final String formatted;

    public TupleSmartTimestamp(long timestamp, ZoneId zoneId, String dateTimePattern) {
        Asserts.assertNonNullOrThrow(zoneId, ExceptionsMessagesUtility.invalidAttribute("TupleSmartTimestamp.zoneId"));
        Asserts.assertNonNullOrThrow(dateTimePattern, ExceptionsMessagesUtility.invalidAttribute("TupleSmartTimestamp.dateTimePattern"));
        this.timestamp = timestamp;
        this.formatted = LocalDateTimeUtility.convertTimestamp(timestamp, zoneId).format(DateTimeFormatter.ofPattern(dateTimePattern));
    }

    public static TupleSmartTimestamp of(long timestamp, ZoneId zoneId, String dateTimePattern) {
        return new TupleSmartTimestamp(timestamp, zoneId, dateTimePattern);
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getFormatted() {
        return this.formatted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TupleSmartTimestamp)) {
            return false;
        }
        TupleSmartTimestamp other = (TupleSmartTimestamp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$formatted = this.getFormatted();
        String other$formatted = other.getFormatted();
        return !(this$formatted == null ? other$formatted != null : !this$formatted.equals(other$formatted));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TupleSmartTimestamp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $formatted = this.getFormatted();
        result = result * 59 + ($formatted == null ? 43 : $formatted.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TupleSmartTimestamp(timestamp=" + this.getTimestamp() + ", formatted=" + this.getFormatted() + ")";
    }
}

