/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.collections;

import io.tech1.framework.domain.asserts.Asserts;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public final class CollectionUtility {
    public static <T> Queue<T> emptyQueue() {
        return new LinkedList();
    }

    public static <T> List<T> union(List<T> one, List<T> second) {
        ArrayList<T> list = new ArrayList<T>(one.size() + second.size());
        list.addAll(one);
        list.addAll(second);
        return list;
    }

    public static <T> Set<T> union(Set<T> one, Set<T> second) {
        HashSet<T> list = new HashSet<T>(one.size() + second.size());
        list.addAll(one);
        list.addAll(second);
        return list;
    }

    public static <T> T safeFirstElement(List<T> list) {
        return (T)Objects.requireNonNull(CollectionUtils.firstElement(list));
    }

    public static <T> T safeFirstElement(Set<T> set) {
        return (T)Objects.requireNonNull(CollectionUtils.firstElement(set));
    }

    public static <T> T safeLastElement(List<T> list) {
        return (T)Objects.requireNonNull(CollectionUtils.lastElement(list));
    }

    public static <T> T safeLastElement(Set<T> set) {
        return (T)Objects.requireNonNull(CollectionUtils.lastElement(set));
    }

    public static <T> List<T> getFirstNElements(List<T> list, long n) {
        Asserts.assertTrueOrThrow(n >= 0L, "Elements quantity can't be negative");
        return list.stream().limit(n).collect(Collectors.toList());
    }

    public static <T> List<T> getLastNElements(List<T> list, long n) {
        Asserts.assertTrueOrThrow(n >= 0L, "Elements quantity can't be negative");
        long remainingCount = (long)list.size() - n;
        long remainingCountOrZero = remainingCount >= 0L ? remainingCount : 0L;
        return list.stream().skip(remainingCountOrZero).collect(Collectors.toList());
    }

    public static BigDecimal maxOrZero(List<BigDecimal> values) {
        return !CollectionUtils.isEmpty(values) ? Collections.max(values) : BigDecimal.ZERO;
    }

    public static BigDecimal minOrZero(List<BigDecimal> values) {
        return !CollectionUtils.isEmpty(values) ? Collections.min(values) : BigDecimal.ZERO;
    }

    @Generated
    private CollectionUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

