/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.cryptography;

import io.tech1.framework.domain.asserts.Asserts;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;

public final class EncryptionUtility {
    private static final String AES_128 = "AES";
    private static final String AES_128_CIPHER_INSTANCE = "AES/GCM/NoPadding";
    private static final int AES_128_KEY_LENGTH = 128;

    public static String encryptAes128(String value, String encryptionInitVector, String encryptionKey) {
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, encrypt. Argument 'value' is required");
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, encrypt. Argument 'encryptionInitVector' is required");
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, encrypt. Argument 'encryptionKey' is required");
        try {
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, encryptionInitVector.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec spec = new SecretKeySpec(encryptionKey.getBytes(StandardCharsets.UTF_8), AES_128);
            Cipher cipher = Cipher.getInstance(AES_128_CIPHER_INSTANCE);
            cipher.init(1, (Key)spec, gcmParameterSpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String message = String.format("Encryption Failure. Algorithm: AES, 128. Value `%s`", value);
            throw new IllegalArgumentException(message);
        }
    }

    public static String decryptAes128(String value, String encryptionInitVector, String encryptionKey) {
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, decrypt. Argument 'value' is required");
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, decrypt. Argument 'encryptionInitVector' is required");
        Asserts.assertNonNullOrThrow(value, "Encryption: AES, 128, decrypt. Argument 'encryptionKey' is required");
        try {
            GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, encryptionInitVector.getBytes(StandardCharsets.UTF_8));
            SecretKeySpec spec = new SecretKeySpec(encryptionKey.getBytes(StandardCharsets.UTF_8), AES_128);
            Cipher cipher = Cipher.getInstance(AES_128_CIPHER_INSTANCE);
            cipher.init(2, (Key)spec, gcmParameterSpec);
            byte[] original = cipher.doFinal(Base64.getDecoder().decode(value));
            return new String(original);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            String message = String.format("Decryption Failure. Algorithm: AES, 128. Value `%s`", value);
            throw new IllegalArgumentException(message);
        }
    }

    @Generated
    private EncryptionUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

