/*
 * Decompiled with CFR 0.152.
 */
package io.tech1.framework.domain.utilities.cryptography;

import io.tech1.framework.domain.asserts.Asserts;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.binary.Hex;

public final class HashingUtility {
    private static final String EXCEPTION_MESSAGE = "Hashing Failure. Value: `%s`, Hashing Key: `%s`, Algorithm: '%s', Exception: '%s'";
    private static final String ASSERTION_VALUE_MESSAGE = "Hashing Algorithm: '%s'. Argument 'value' is required";
    private static final String ASSERTION_HASHING_KEY_MESSAGE = "Hashing Algorithm: '%s'. Argument 'hashingKey' is required";
    private static final String SHA_256 = "HmacSHA256";
    private static final String SHA_384 = "HmacSHA384";
    private static final String SHA_512 = "HmacSHA512";

    public static String hmacSha256(String value, String hashingKey) {
        return HashingUtility.shaByAlgorithm(value, hashingKey, SHA_256);
    }

    public static String hmacSha384(String value, String hashingKey) {
        return HashingUtility.shaByAlgorithm(value, hashingKey, SHA_384);
    }

    public static String hmacSha512(String value, String hashingKey) {
        return HashingUtility.shaByAlgorithm(value, hashingKey, SHA_512);
    }

    private static String shaByAlgorithm(String value, String hashingKey, String algorithm) {
        Asserts.assertNonNullOrThrow(value, String.format(ASSERTION_VALUE_MESSAGE, algorithm));
        Asserts.assertNonNullOrThrow(hashingKey, String.format(ASSERTION_HASHING_KEY_MESSAGE, algorithm));
        try {
            Mac mac = Mac.getInstance(algorithm);
            SecretKeySpec keySpec = new SecretKeySpec(hashingKey.getBytes(StandardCharsets.UTF_8), algorithm);
            mac.init(keySpec);
            return Hex.encodeHexString((byte[])mac.doFinal(value.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            String message = String.format(EXCEPTION_MESSAGE, value, hashingKey, algorithm, ex.getClass().getSimpleName());
            throw new IllegalArgumentException(message);
        }
    }

    @Generated
    private HashingUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

